/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.api.utils.log.Profiler;
import org.sonar.java.AnalysisException;
import org.sonar.java.Measurer;
import org.sonar.java.SonarComponents;
import org.sonar.java.annotations.VisibleForTesting;
import org.sonar.java.ast.JavaAstScanner;
import org.sonar.java.ast.visitors.FileLinesVisitor;
import org.sonar.java.ast.visitors.SyntaxHighlighterVisitor;
import org.sonar.java.collections.CollectionUtils;
import org.sonar.java.filters.SonarJavaIssueFilter;
import org.sonar.java.model.JParserConfig;
import org.sonar.java.model.VisitorsBridge;
import org.sonar.plugins.java.api.JavaCheck;
import org.sonar.plugins.java.api.JavaResourceLocator;
import org.sonar.plugins.java.api.JavaVersion;
import org.sonarsource.analyzer.commons.collections.ListUtils;
import org.sonarsource.performance.measure.PerformanceMeasure;

public class JavaFrontend {
    private static final Logger LOG = Loggers.get(JavaFrontend.class);
    private static final String BATCH_ERROR_MESSAGE = "Batch Mode failed, analysis of Java Files stopped.";
    private final JavaVersion javaVersion;
    private final SonarComponents sonarComponents;
    private final List<File> globalClasspath;
    private final JavaAstScanner astScanner;
    private final JavaAstScanner astScannerForTests;
    private final JavaAstScanner astScannerForGeneratedFiles;

    public JavaFrontend(JavaVersion javaVersion, @Nullable SonarComponents sonarComponents, @Nullable Measurer measurer, JavaResourceLocator javaResourceLocator, @Nullable SonarJavaIssueFilter postAnalysisIssueFilter, JavaCheck ... visitors) {
        this.javaVersion = javaVersion;
        this.sonarComponents = sonarComponents;
        ArrayList<JavaCheck> commonVisitors = new ArrayList<JavaCheck>();
        commonVisitors.add(javaResourceLocator);
        if (postAnalysisIssueFilter != null) {
            commonVisitors.add(postAnalysisIssueFilter);
        }
        List<JavaCheck> codeVisitors = ListUtils.concat(new List[]{commonVisitors, Arrays.asList(visitors)});
        ArrayList<JavaCheck> testCodeVisitors = new ArrayList<JavaCheck>(commonVisitors);
        if (measurer != null) {
            List<Measurer> measurers = Collections.singletonList(measurer);
            codeVisitors = ListUtils.concat(new Iterable[]{measurers, codeVisitors});
            testCodeVisitors.add(measurer.new Measurer.TestFileMeasurer());
        }
        ArrayList<File> classpath = new ArrayList();
        ArrayList<File> testClasspath = new ArrayList();
        ArrayList<JavaCheck> jspCodeVisitors = new ArrayList();
        ArrayList<File> jspClasspath = new ArrayList();
        boolean inAndroidContext = false;
        if (sonarComponents != null) {
            if (!sonarComponents.isSonarLintContext()) {
                codeVisitors = ListUtils.concat(new Iterable[]{codeVisitors, Arrays.asList(new FileLinesVisitor(sonarComponents), new SyntaxHighlighterVisitor(sonarComponents))});
                testCodeVisitors.add(new SyntaxHighlighterVisitor(sonarComponents));
            }
            classpath = sonarComponents.getJavaClasspath();
            testClasspath = sonarComponents.getJavaTestClasspath();
            jspClasspath = sonarComponents.getJspClasspath();
            testCodeVisitors.addAll(sonarComponents.testChecks());
            jspCodeVisitors = sonarComponents.jspChecks();
            inAndroidContext = sonarComponents.inAndroidContext();
        }
        this.globalClasspath = Stream.of(classpath, testClasspath, jspClasspath).flatMap(Collection::stream).distinct().collect(Collectors.toList());
        this.astScanner = new JavaAstScanner(sonarComponents);
        this.astScanner.setVisitorBridge(JavaFrontend.createVisitorBridge(codeVisitors, classpath, javaVersion, sonarComponents, inAndroidContext));
        this.astScannerForTests = new JavaAstScanner(sonarComponents);
        this.astScannerForTests.setVisitorBridge(JavaFrontend.createVisitorBridge(testCodeVisitors, testClasspath, javaVersion, sonarComponents, inAndroidContext));
        this.astScannerForGeneratedFiles = new JavaAstScanner(sonarComponents);
        this.astScannerForGeneratedFiles.setVisitorBridge(JavaFrontend.createVisitorBridge(jspCodeVisitors, jspClasspath, javaVersion, sonarComponents, inAndroidContext));
    }

    private static VisitorsBridge createVisitorBridge(Iterable<JavaCheck> codeVisitors, List<File> classpath, JavaVersion javaVersion, @Nullable SonarComponents sonarComponents, boolean inAndroidContext) {
        VisitorsBridge visitorsBridge = new VisitorsBridge(codeVisitors, classpath, sonarComponents);
        visitorsBridge.setJavaVersion(javaVersion);
        visitorsBridge.setInAndroidContext(inAndroidContext);
        return visitorsBridge;
    }

    @VisibleForTesting
    boolean analysisCancelled() {
        return this.sonarComponents != null && this.sonarComponents.analysisCancelled();
    }

    public void scan(Iterable<InputFile> sourceFiles, Iterable<InputFile> testFiles, Iterable<? extends InputFile> generatedFiles) {
        boolean fileByFileMode;
        boolean isSonarLint = this.sonarComponents != null && this.sonarComponents.isSonarLintContext();
        boolean bl = fileByFileMode = isSonarLint || !this.isBatchModeEnabled();
        if (fileByFileMode) {
            JavaFrontend.scanAndMeasureTask(sourceFiles, this.astScanner::scan, "Main");
            JavaFrontend.scanAndMeasureTask(testFiles, this.astScannerForTests::scan, "Test");
            JavaFrontend.scanAndMeasureTask(generatedFiles, this.astScannerForGeneratedFiles::scan, "Generated");
        } else if (this.isAutoScan()) {
            this.scanAsBatch(new AutoScanBatchContext(), sourceFiles, testFiles);
        } else {
            this.scanAsBatch(new DefaultBatchModeContext(this.astScanner, "Main"), sourceFiles);
            this.scanAsBatch(new DefaultBatchModeContext(this.astScannerForTests, "Test"), testFiles);
            this.scanAsBatch(new DefaultBatchModeContext(this.astScannerForGeneratedFiles, "Generated"), generatedFiles);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scanAsBatch(BatchModeContext context, Iterable<? extends InputFile> ... inputFiles) {
        block8: {
            ArrayList<InputFile> files = new ArrayList<InputFile>();
            for (Iterable<? extends InputFile> group : inputFiles) {
                files.addAll(this.astScanner.filterModuleInfo(group).collect(Collectors.toList()));
            }
            try {
                try {
                    if (!files.isEmpty()) {
                        this.scanInBatches(context, files);
                    }
                }
                finally {
                    context.endOfAnalysis();
                }
            }
            catch (AnalysisException e) {
                throw e;
            }
            catch (Exception e) {
                this.astScanner.checkInterrupted(e);
                this.astScannerForTests.checkInterrupted(e);
                this.astScannerForGeneratedFiles.checkInterrupted(e);
                LOG.error(BATCH_ERROR_MESSAGE, (Throwable)e);
                if (!this.astScanner.shouldFailAnalysis()) break block8;
                throw new AnalysisException(BATCH_ERROR_MESSAGE, e);
            }
        }
    }

    private void scanInBatches(BatchModeContext context, List<InputFile> allInputFiles) {
        long batchModeSizeInKB = this.sonarComponents.getBatchModeSizeInKB();
        if (batchModeSizeInKB < 0L || batchModeSizeInKB >= 9223372036854775L) {
            LOG.debug("Scanning in a single batch");
            this.scanBatch(context, allInputFiles);
        } else {
            long batchSize = batchModeSizeInKB * 1000L;
            LOG.debug("Scanning with batch size {} B", (Object)batchSize);
            BatchGenerator generator = new BatchGenerator(allInputFiles.iterator(), batchSize);
            while (generator.hasNext()) {
                List<InputFile> batch = generator.next();
                this.scanBatch(context, batch);
            }
        }
    }

    private <T extends InputFile> void scanBatch(BatchModeContext context, List<T> allFiles) {
        JParserConfig.Mode.BATCH.create(JParserConfig.effectiveJavaVersion(this.javaVersion), context.getClasspath()).parse(allFiles, this::analysisCancelled, (input, result) -> JavaFrontend.scanAsBatchCallback(input, result, context));
    }

    private static void scanAsBatchCallback(InputFile inputFile, JParserConfig.Result result, BatchModeContext context) {
        JavaAstScanner scanner = context.selectScanner(inputFile);
        PerformanceMeasure.Duration duration = PerformanceMeasure.start(context.descriptor(inputFile));
        scanner.simpleScan(inputFile, result, ast -> {});
        duration.stop();
    }

    @VisibleForTesting
    boolean isBatchModeEnabled() {
        return this.sonarComponents != null && this.sonarComponents.isBatchModeEnabled();
    }

    @VisibleForTesting
    boolean isAutoScan() {
        return this.sonarComponents != null && this.sonarComponents.isAutoScan();
    }

    private static <T> void scanAndMeasureTask(Iterable<T> files, Consumer<Iterable<T>> action, String descriptor) {
        if (CollectionUtils.size(files) > 0) {
            PerformanceMeasure.Duration mainDuration = PerformanceMeasure.start(descriptor);
            Profiler profiler = Profiler.create((Logger)LOG).startInfo(String.format("Java \"%s\" source files AST scan", descriptor));
            action.accept(files);
            profiler.stopInfo();
            mainDuration.stop();
        } else {
            LOG.info(String.format("No \"%s\" source files to scan.", descriptor));
        }
    }

    class AutoScanBatchContext
    implements BatchModeContext {
        AutoScanBatchContext() {
        }

        @Override
        public String descriptor(InputFile input) {
            return input.type() == InputFile.Type.TEST ? "Test" : "Main";
        }

        @Override
        public List<File> getClasspath() {
            return JavaFrontend.this.globalClasspath;
        }

        @Override
        public JavaAstScanner selectScanner(InputFile input) {
            return input.type() == InputFile.Type.TEST ? JavaFrontend.this.astScannerForTests : JavaFrontend.this.astScanner;
        }

        @Override
        public void endOfAnalysis() {
            JavaFrontend.this.astScanner.endOfAnalysis();
            JavaFrontend.this.astScannerForTests.endOfAnalysis();
            JavaFrontend.this.astScannerForGeneratedFiles.endOfAnalysis();
        }
    }

    static interface BatchModeContext {
        public String descriptor(InputFile var1);

        public List<File> getClasspath();

        public JavaAstScanner selectScanner(InputFile var1);

        public void endOfAnalysis();
    }

    static class DefaultBatchModeContext
    implements BatchModeContext {
        private final JavaAstScanner scanner;
        private final String descriptor;

        public DefaultBatchModeContext(JavaAstScanner scanner, String descriptor) {
            this.scanner = scanner;
            this.descriptor = descriptor;
        }

        @Override
        public String descriptor(InputFile input) {
            return this.descriptor;
        }

        @Override
        public List<File> getClasspath() {
            return this.scanner.getClasspath();
        }

        @Override
        public JavaAstScanner selectScanner(InputFile input) {
            return this.scanner;
        }

        @Override
        public void endOfAnalysis() {
            this.scanner.endOfAnalysis();
        }
    }

    static class BatchGenerator {
        public final long batchSizeInBytes;
        private final Iterator<InputFile> source;
        private InputFile buffer = null;

        public BatchGenerator(Iterator<InputFile> source, long batchSizeInBytes) {
            this.source = source;
            this.batchSizeInBytes = batchSizeInBytes;
        }

        public boolean hasNext() {
            return this.buffer != null || this.source.hasNext();
        }

        public List<InputFile> next() {
            long batchSize;
            List<InputFile> batch = this.clearBuffer();
            long l = batchSize = batch.isEmpty() ? 0L : batch.get(0).file().length();
            while (this.source.hasNext() && batchSize <= this.batchSizeInBytes) {
                this.buffer = this.source.next();
                if ((batchSize += this.buffer.file().length()) > this.batchSizeInBytes) {
                    if (batch.isEmpty()) {
                        batch.add(this.buffer);
                        this.buffer = null;
                    }
                    return batch;
                }
                batch.add(this.buffer);
            }
            this.buffer = null;
            return batch;
        }

        private List<InputFile> clearBuffer() {
            if (this.buffer == null) {
                return new ArrayList<InputFile>();
            }
            ArrayList<InputFile> batch = new ArrayList<InputFile>();
            batch.add(this.buffer);
            this.buffer = null;
            return batch;
        }
    }
}

