/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.flex.cobertura;

import com.ctc.wstx.stax.WstxInputFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.text.ParseException;
import java.util.HashMap;
import java.util.Locale;
import javax.annotation.CheckForNull;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import org.apache.commons.lang.StringUtils;
import org.codehaus.staxmate.SMInputFactory;
import org.codehaus.staxmate.in.SMHierarchicCursor;
import org.codehaus.staxmate.in.SMInputCursor;
import org.sonar.api.batch.fs.FilePredicate;
import org.sonar.api.batch.fs.FilePredicates;
import org.sonar.api.batch.fs.FileSystem;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.batch.sensor.coverage.NewCoverage;
import org.sonar.api.utils.ParsingUtils;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;

public class CoberturaReportParser {
    private static final Logger LOG = Loggers.get(CoberturaReportParser.class);

    private CoberturaReportParser() {
    }

    public static void parseReport(File xmlFile, SensorContext context) {
        StaxParser parser = new StaxParser(rootCursor -> {
            rootCursor.advance();
            CoberturaReportParser.collectPackageMeasures(rootCursor.descendantElementCursor("package"), context);
        });
        try {
            parser.parse(xmlFile);
        }
        catch (XMLStreamException e) {
            throw new IllegalStateException(e);
        }
    }

    private static void collectPackageMeasures(SMInputCursor pack, SensorContext context) throws XMLStreamException {
        while (pack.getNext() != null) {
            CoberturaReportParser.collectFileMeasures(context, pack.descendantElementCursor("class"));
        }
    }

    private static void collectFileMeasures(SensorContext context, SMInputCursor clazz) throws XMLStreamException {
        FileSystem fileSystem = context.fileSystem();
        FilePredicates predicates = fileSystem.predicates();
        HashMap<String, InputFile> inputFileByFilename = new HashMap<String, InputFile>();
        while (clazz.getNext() != null) {
            InputFile inputFile;
            String fileName = clazz.getAttrValue("filename");
            if (inputFileByFilename.containsKey(fileName)) {
                inputFile = (InputFile)inputFileByFilename.get(fileName);
            } else {
                inputFile = CoberturaReportParser.findInputFile(fileSystem, predicates, fileName);
                inputFileByFilename.put(fileName, inputFile);
                if (inputFile == null && !fileName.endsWith(".mxml")) {
                    LOG.warn("Cannot save coverage result for file: {}, because resource not found.", (Object)fileName);
                }
            }
            if (inputFile != null) {
                CoberturaReportParser.collectFileData(clazz, context.newCoverage().onFile(inputFile));
                continue;
            }
            SMInputCursor line = clazz.childElementCursor("lines").advance().childElementCursor("line");
            while (line.getNext() != null) {
            }
        }
    }

    @CheckForNull
    private static InputFile findInputFile(FileSystem fileSystem, FilePredicates predicates, String fileName) {
        String key = fileName.startsWith(File.separator) ? fileName : File.separator + fileName;
        return fileSystem.inputFile(predicates.and(new FilePredicate[]{predicates.matchesPathPattern("**" + key.replace(File.separator, "/")), predicates.hasType(InputFile.Type.MAIN), predicates.hasLanguage("flex")}));
    }

    private static void collectFileData(SMInputCursor clazz, NewCoverage newCoverage) throws XMLStreamException {
        SMInputCursor line = clazz.childElementCursor("lines").advance().childElementCursor("line");
        while (line.getNext() != null) {
            int lineId = Integer.parseInt(line.getAttrValue("number"));
            try {
                newCoverage.lineHits(lineId, (int)ParsingUtils.parseNumber((String)line.getAttrValue("hits"), (Locale)Locale.ENGLISH));
            }
            catch (ParseException e) {
                throw new IllegalStateException(e);
            }
            String isBranch = line.getAttrValue("branch");
            String text = line.getAttrValue("condition-coverage");
            if (!StringUtils.equals(isBranch, "true") || !StringUtils.isNotBlank(text)) continue;
            String[] conditions = StringUtils.split(StringUtils.substringBetween(text, "(", ")"), "/");
            newCoverage.conditions(lineId, Integer.parseInt(conditions[1]), Integer.parseInt(conditions[0]));
        }
        newCoverage.save();
    }

    @FunctionalInterface
    private static interface XmlStreamHandler {
        public void stream(SMHierarchicCursor var1) throws XMLStreamException;
    }

    private static class StaxParser {
        private XmlStreamHandler streamHandler;
        private SMInputFactory inf;

        public StaxParser(XmlStreamHandler streamHandler) {
            this.streamHandler = streamHandler;
            XMLInputFactory xmlFactory = XMLInputFactory.newInstance();
            if (xmlFactory instanceof WstxInputFactory) {
                WstxInputFactory wstxInputfactory = (WstxInputFactory)xmlFactory;
                wstxInputfactory.configureForLowMemUsage();
                wstxInputfactory.getConfig().setUndeclaredEntityResolver((publicID, systemID, baseURI, namespace) -> namespace);
            }
            xmlFactory.setProperty("javax.xml.stream.isValidating", false);
            xmlFactory.setProperty("javax.xml.stream.supportDTD", false);
            xmlFactory.setProperty("javax.xml.stream.isNamespaceAware", false);
            xmlFactory.setProperty("javax.xml.stream.isSupportingExternalEntities", false);
            this.inf = new SMInputFactory(xmlFactory);
        }

        public void parse(File xmlFile) throws XMLStreamException {
            try (FileInputStream input = new FileInputStream(xmlFile);){
                this.parse(this.inf.rootElementCursor(input));
            }
            catch (IOException e) {
                throw new XMLStreamException(e);
            }
        }

        private void parse(SMHierarchicCursor rootCursor) throws XMLStreamException {
            try {
                this.streamHandler.stream(rootCursor);
            }
            finally {
                rootCursor.getStreamReader().closeCompletely();
            }
        }
    }
}

