/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.flex.metrics;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import java.util.Arrays;
import java.util.List;
import org.sonar.flex.FlexGrammar;
import org.sonar.flex.FlexKeyword;
import org.sonar.flex.FlexPunctuator;
import org.sonar.flex.FlexVisitor;

public class ComplexityVisitor
extends FlexVisitor {
    private int complexity;

    public int getComplexity() {
        return this.complexity;
    }

    @Override
    public List<AstNodeType> subscribedTo() {
        return Arrays.asList(FlexGrammar.FUNCTION_DEF, FlexGrammar.FUNCTION_EXPR, FlexGrammar.IF_STATEMENT, FlexGrammar.FOR_STATEMENT, FlexGrammar.WHILE_STATEMENT, FlexGrammar.DO_STATEMENT, FlexKeyword.CASE, FlexPunctuator.QUERY, FlexGrammar.LOGICAL_AND_OPERATOR, FlexGrammar.LOGICAL_OR_OPERATOR);
    }

    @Override
    public void visitFile(AstNode node) {
        this.complexity = 0;
    }

    @Override
    public void visitNode(AstNode astNode) {
        ++this.complexity;
    }

    public static int complexity(AstNode root) {
        ComplexityVisitor visitor = new ComplexityVisitor();
        visitor.scanNode(root);
        return visitor.complexity;
    }

    public static int functionComplexity(AstNode functionDef) {
        FunctionComplexityVisitor visitor = new FunctionComplexityVisitor(functionDef);
        visitor.scanNode(functionDef);
        return visitor.complexity;
    }

    private static class FunctionComplexityVisitor
    extends ComplexityVisitor {
        private final AstNode functionDef;
        private int nestingLevel = 0;

        public FunctionComplexityVisitor(AstNode functionDef) {
            this.functionDef = functionDef;
        }

        @Override
        public void visitNode(AstNode astNode) {
            if (this.isNestedFunction(astNode)) {
                ++this.nestingLevel;
            }
            if (this.nestingLevel == 0) {
                super.visitNode(astNode);
            }
        }

        @Override
        public void leaveNode(AstNode node) {
            if (this.isNestedFunction(node)) {
                --this.nestingLevel;
            }
        }

        private boolean isNestedFunction(AstNode astNode) {
            return astNode.is(FlexGrammar.FUNCTION_DEF, FlexGrammar.FUNCTION_EXPR) && astNode != this.functionDef;
        }
    }
}

