/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.flex.checks.utils;

import com.sonar.sslr.api.AstNode;
import java.util.ArrayList;
import java.util.List;
import org.sonar.flex.FlexGrammar;
import org.sonar.flex.FlexKeyword;
import org.sonar.flex.checks.utils.Preconditions;

public final class Variable {
    private Variable() {
    }

    public static String getName(AstNode varDeclStatement) {
        Preconditions.checkState(varDeclStatement.is(FlexGrammar.VARIABLE_DECLARATION_STATEMENT));
        return varDeclStatement.getFirstChild(FlexGrammar.VARIABLE_DEF).getFirstChild(FlexGrammar.VARIABLE_BINDING_LIST).getFirstChild(FlexGrammar.VARIABLE_BINDING).getFirstChild(FlexGrammar.TYPED_IDENTIFIER).getFirstChild(FlexGrammar.IDENTIFIER).getTokenValue();
    }

    public static boolean isVariable(AstNode directive) {
        AstNode variableDecStmt;
        Preconditions.checkState(directive.is(FlexGrammar.DIRECTIVE));
        if (directive.getFirstChild(FlexGrammar.ANNOTABLE_DIRECTIVE) != null && (variableDecStmt = directive.getFirstChild(FlexGrammar.ANNOTABLE_DIRECTIVE).getFirstChild(FlexGrammar.VARIABLE_DECLARATION_STATEMENT)) != null) {
            return variableDecStmt.getFirstChild(FlexGrammar.VARIABLE_DEF).getFirstChild(FlexGrammar.VARIABLE_DEF_KIND).getFirstChild().is(FlexKeyword.VAR);
        }
        return false;
    }

    public static boolean isConst(AstNode directive) {
        AstNode variableDecStmt;
        Preconditions.checkState(directive.is(FlexGrammar.DIRECTIVE));
        if (directive.getFirstChild(FlexGrammar.ANNOTABLE_DIRECTIVE) != null && (variableDecStmt = directive.getFirstChild(FlexGrammar.ANNOTABLE_DIRECTIVE).getFirstChild(FlexGrammar.VARIABLE_DECLARATION_STATEMENT)) != null) {
            return variableDecStmt.getFirstChild(FlexGrammar.VARIABLE_DEF).getFirstChild(FlexGrammar.VARIABLE_DEF_KIND).getFirstChild().is(FlexKeyword.CONST);
        }
        return false;
    }

    public static List<AstNode> getDeclaredIdentifiers(AstNode varDeclStatement) {
        Preconditions.checkState(varDeclStatement.is(FlexGrammar.VARIABLE_DECLARATION_STATEMENT));
        ArrayList<AstNode> identifiers = new ArrayList<AstNode>();
        if (varDeclStatement.is(FlexGrammar.VARIABLE_DECLARATION_STATEMENT)) {
            AstNode varBindingList = varDeclStatement.getFirstChild(FlexGrammar.VARIABLE_DEF).getFirstChild(FlexGrammar.VARIABLE_BINDING_LIST);
            for (AstNode varBinding : varBindingList.getChildren(FlexGrammar.VARIABLE_BINDING)) {
                identifiers.add(varBinding.getFirstChild(FlexGrammar.TYPED_IDENTIFIER).getFirstChild(FlexGrammar.IDENTIFIER));
            }
        }
        return identifiers;
    }
}

