/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.flex.checks;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import com.sonar.sslr.api.Token;
import java.util.Arrays;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.flex.FlexCheck;
import org.sonar.flex.FlexGrammar;
import org.sonar.flex.FlexPunctuator;

@Rule(key="S1438")
public class SemicolonCheck
extends FlexCheck {
    @Override
    public List<AstNodeType> subscribedTo() {
        return Arrays.asList(FlexGrammar.EOS, FlexGrammar.EOS_NO_LB);
    }

    @Override
    public void visitNode(AstNode astNode) {
        Token lastToken = astNode.getLastToken();
        if (lastToken == null || !FlexPunctuator.SEMICOLON.getValue().equals(lastToken.getValue())) {
            this.addIssue("Add a semicolon at the end of this statement", astNode.getParent().getLastToken());
        }
    }
}

