/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.flex.checks;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.flex.FlexCheck;
import org.sonar.flex.FlexGrammar;
import org.sonar.flex.FlexKeyword;
import org.sonar.flex.checks.utils.Function;

@Rule(key="S1470")
public class OverrideEventCloneFunctionCheck
extends FlexCheck {
    private static final String EVENT_TYPE_NAME = "Event";

    @Override
    public List<AstNodeType> subscribedTo() {
        return Collections.singletonList(FlexGrammar.CLASS_DEF);
    }

    @Override
    public void visitNode(AstNode astNode) {
        if (!OverrideEventCloneFunctionCheck.isExtendingEvent(astNode)) {
            return;
        }
        List<AstNode> classDirectives = astNode.getFirstChild(FlexGrammar.BLOCK).getFirstChild(FlexGrammar.DIRECTIVES).getChildren(FlexGrammar.DIRECTIVE);
        for (AstNode directive : classDirectives) {
            if (!OverrideEventCloneFunctionCheck.isOverridingFunction(directive) || !OverrideEventCloneFunctionCheck.isCloneFunction(directive)) continue;
            return;
        }
        String className = astNode.getFirstChild(FlexGrammar.CLASS_NAME).getFirstChild(FlexGrammar.CLASS_IDENTIFIERS).getLastChild().getTokenValue();
        this.addIssue(MessageFormat.format("Make this class \"{0}\" override \"Event.clone()\" function.", className), astNode);
    }

    private static boolean isCloneFunction(AstNode directive) {
        AstNode functionDef = directive.getFirstChild(FlexGrammar.ANNOTABLE_DIRECTIVE).getFirstChild(FlexGrammar.FUNCTION_DEF);
        String functionName = Function.getName(functionDef);
        return "clone".equals(functionName) && EVENT_TYPE_NAME.equals(OverrideEventCloneFunctionCheck.getResultType(functionDef));
    }

    private static String getResultType(AstNode functionDef) {
        AstNode resultType = functionDef.getFirstChild(FlexGrammar.FUNCTION_COMMON).getFirstChild(FlexGrammar.FUNCTION_SIGNATURE).getFirstChild(FlexGrammar.RESULT_TYPE);
        if (resultType != null && resultType.getFirstChild(FlexGrammar.TYPE_EXPR) != null) {
            return resultType.getFirstChild(FlexGrammar.TYPE_EXPR).getTokenValue();
        }
        return null;
    }

    private static boolean isExtendingEvent(AstNode classDef) {
        AstNode qualifiedId;
        AstNode inheritenceNode = classDef.getFirstChild(FlexGrammar.INHERITENCE);
        return inheritenceNode != null && inheritenceNode.getFirstChild(FlexKeyword.EXTENDS) != null && (qualifiedId = inheritenceNode.getFirstChild(FlexGrammar.TYPE_EXPR).getLastChild()).is(FlexGrammar.QUALIFIED_IDENTIFIER) && EVENT_TYPE_NAME.equals(qualifiedId.getTokenValue());
    }

    private static boolean isOverridingFunction(AstNode directive) {
        return OverrideEventCloneFunctionCheck.isFunctionWithAttributes(directive) && OverrideEventCloneFunctionCheck.isOverriding(directive);
    }

    private static boolean isFunctionWithAttributes(AstNode directive) {
        return directive.getFirstChild(FlexGrammar.ANNOTABLE_DIRECTIVE) != null && directive.getFirstChild(FlexGrammar.ANNOTABLE_DIRECTIVE).getFirstChild().is(FlexGrammar.FUNCTION_DEF) && directive.getFirstChild(FlexGrammar.ATTRIBUTES) != null;
    }

    private static boolean isOverriding(AstNode directive) {
        for (AstNode attribute : directive.getFirstChild(FlexGrammar.ATTRIBUTES).getChildren()) {
            if (!attribute.getFirstChild().is(FlexGrammar.ATTRIBUTE_EXPR) || attribute.getFirstChild().getNumberOfChildren() != 1 || !attribute.getFirstChild().getFirstChild(FlexGrammar.IDENTIFIER).getTokenValue().equals(FlexKeyword.OVERRIDE.getValue())) continue;
            return true;
        }
        return false;
    }
}

