/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.flex.checks;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.flex.FlexCheck;
import org.sonar.flex.FlexGrammar;
import org.sonar.flex.checks.utils.Function;
import org.sonar.flex.checks.utils.Variable;

@Rule(key="S117")
public class LocalVarAndParameterNameCheck
extends FlexCheck {
    private static final String DEFAULT = "^[_a-z][a-zA-Z0-9]*$";
    private static final String MESSAGE = "Rename this local variable \"{0}\" to match the regular expression {1}";
    private Pattern pattern = null;
    @RuleProperty(key="format", description="Regular expression used to check the names against.", defaultValue="^[_a-z][a-zA-Z0-9]*$")
    String format = "^[_a-z][a-zA-Z0-9]*$";

    @Override
    public List<AstNodeType> subscribedTo() {
        return Collections.singletonList(FlexGrammar.FUNCTION_DEF);
    }

    @Override
    public void visitFile(@Nullable AstNode astNode) {
        if (this.pattern == null) {
            this.pattern = Pattern.compile(this.format);
        }
    }

    @Override
    public void visitNode(AstNode astNode) {
        this.checkFunctionParametersName(astNode);
        if (astNode.getFirstChild(FlexGrammar.FUNCTION_COMMON).getFirstChild(FlexGrammar.BLOCK) != null) {
            this.checkLocalVariableName(astNode.getFirstChild(FlexGrammar.FUNCTION_COMMON).getFirstChild(FlexGrammar.BLOCK).getFirstChild(FlexGrammar.DIRECTIVES).getChildren(FlexGrammar.DIRECTIVE));
        }
    }

    private void checkLocalVariableName(List<AstNode> functionDirectives) {
        for (AstNode directive : functionDirectives) {
            if (!Variable.isVariable(directive)) continue;
            AstNode variableDeclStatement = directive.getFirstChild(FlexGrammar.ANNOTABLE_DIRECTIVE).getFirstChild(FlexGrammar.VARIABLE_DECLARATION_STATEMENT);
            this.checkVariableDeclStatement(variableDeclStatement);
        }
    }

    private void checkVariableDeclStatement(AstNode variableDeclStatement) {
        for (AstNode identifier : Variable.getDeclaredIdentifiers(variableDeclStatement)) {
            String varName = identifier.getTokenValue();
            if (this.pattern.matcher(varName).matches()) continue;
            this.addIssue(MessageFormat.format(MESSAGE, varName, this.format), identifier);
        }
    }

    private void checkFunctionParametersName(AstNode functionDef) {
        for (AstNode paramIdentifier : Function.getParametersIdentifiers(functionDef)) {
            String paramName = paramIdentifier.getTokenValue();
            if (this.pattern.matcher(paramName).matches()) continue;
            this.addIssue(MessageFormat.format(MESSAGE, paramName, this.format), paramIdentifier);
        }
    }
}

