/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.flex.checks;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import java.util.Arrays;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.flex.FlexCheck;
import org.sonar.flex.FlexGrammar;

@Rule(key="FunctionSinglePointOfExit")
public class FunctionSinglePointOfExitCheck
extends FlexCheck {
    private int returnStatements;

    @Override
    public List<AstNodeType> subscribedTo() {
        return Arrays.asList(FlexGrammar.FUNCTION_DEF, FlexGrammar.RETURN_STATEMENT);
    }

    @Override
    public void visitNode(AstNode node) {
        if (node.is(FlexGrammar.FUNCTION_DEF)) {
            this.returnStatements = 0;
        } else if (node.is(FlexGrammar.RETURN_STATEMENT)) {
            ++this.returnStatements;
        }
    }

    @Override
    public void leaveNode(AstNode node) {
        if (node.is(FlexGrammar.FUNCTION_DEF) && this.returnStatements != 0 && (this.returnStatements > 1 || !FunctionSinglePointOfExitCheck.hasReturnAtEnd(node))) {
            this.addIssue("A function shall have a single point of exit at the end of the function.", node);
        }
    }

    private static boolean hasReturnAtEnd(AstNode functionDefinitionNode) {
        AstNode statementNode;
        AstNode lastDirectiveNode = functionDefinitionNode.getFirstChild(FlexGrammar.FUNCTION_COMMON).getFirstChild(FlexGrammar.BLOCK).getFirstChild(FlexGrammar.DIRECTIVES).getLastChild();
        return lastDirectiveNode != null && (statementNode = lastDirectiveNode.getFirstChild(FlexGrammar.STATEMENT)) != null && statementNode.getFirstChild().is(FlexGrammar.RETURN_STATEMENT);
    }
}

