/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.flex.checks;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import java.util.Arrays;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.flex.FlexCheck;
import org.sonar.flex.FlexGrammar;
import org.sonar.flex.metrics.ComplexityVisitor;

@Rule(key="FunctionComplexity")
public class FunctionComplexityCheck
extends FlexCheck {
    private static final int DEFAULT_MAXIMUM_FUNCTION_COMPLEXITY_THRESHOLD = 10;
    @RuleProperty(key="maximumFunctionComplexityThreshold", description="The maximum authorized complexity.", defaultValue="10")
    private int maximumFunctionComplexityThreshold = 10;

    @Override
    public List<AstNodeType> subscribedTo() {
        return Arrays.asList(FlexGrammar.FUNCTION_DEF, FlexGrammar.FUNCTION_EXPR);
    }

    @Override
    public void visitNode(AstNode node) {
        int functionComplexity = ComplexityVisitor.functionComplexity(node);
        if (functionComplexity > this.maximumFunctionComplexityThreshold) {
            String message = String.format("Function has a complexity of %s which is greater than %s authorized.", functionComplexity, this.maximumFunctionComplexityThreshold);
            this.addIssueWithCost(message, node, (double)functionComplexity - (double)this.maximumFunctionComplexityThreshold);
        }
    }

    public void setMaximumFunctionComplexityThreshold(int threshold) {
        this.maximumFunctionComplexityThreshold = threshold;
    }
}

