/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.flex.checks;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import java.util.Collections;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.flex.FlexCheck;
import org.sonar.flex.FlexGrammar;
import org.sonar.flex.FlexPunctuator;

@Rule(key="S108")
public class EmptyNestedBlockCheck
extends FlexCheck {
    @Override
    public List<AstNodeType> subscribedTo() {
        return Collections.singletonList(FlexGrammar.BLOCK);
    }

    @Override
    public void visitNode(AstNode astNode) {
        if (!astNode.getFirstChild(FlexGrammar.DIRECTIVES).hasChildren() && EmptyNestedBlockCheck.isNested(astNode) && !EmptyNestedBlockCheck.hasComment(astNode)) {
            this.addIssue("Either remove or fill this block of code.", astNode);
        }
    }

    private static boolean isNested(AstNode blockNode) {
        return !blockNode.getParent().is(FlexGrammar.CLASS_DEF, FlexGrammar.INTERFACE_DEF, FlexGrammar.PACKAGE_DEF, FlexGrammar.FUNCTION_COMMON);
    }

    private static boolean hasComment(AstNode blockNode) {
        return blockNode.getFirstChild(FlexPunctuator.RCURLYBRACE).getToken().hasTrivia();
    }
}

