/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.flex.checks;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import java.text.MessageFormat;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Deque;
import java.util.List;
import javax.annotation.Nullable;
import org.sonar.check.Rule;
import org.sonar.flex.FlexCheck;
import org.sonar.flex.FlexGrammar;
import org.sonar.flex.checks.utils.Clazz;
import org.sonar.flex.checks.utils.Function;

@Rule(key="S1467")
public class ConstructorCallsDispatchEventCheck
extends FlexCheck {
    boolean isInClass;
    private Deque<ClassState> classStack = new ArrayDeque<ClassState>();

    @Override
    public List<AstNodeType> subscribedTo() {
        return Arrays.asList(FlexGrammar.CLASS_DEF, FlexGrammar.FUNCTION_DEF, FlexGrammar.PRIMARY_EXPR);
    }

    @Override
    public void visitFile(@Nullable AstNode astNode) {
        this.classStack.clear();
    }

    @Override
    public void visitNode(AstNode astNode) {
        if (astNode.is(FlexGrammar.CLASS_DEF)) {
            this.isInClass = true;
            String className = Clazz.getName(astNode);
            this.classStack.push(new ClassState(className));
        } else if (this.isConstructor(astNode)) {
            this.classStack.peek().isInConstructor = true;
        } else if (this.isCallToDispatchEventInConstructor(astNode)) {
            this.addIssue(MessageFormat.format("Remove this event dispatch from the \"{0}\" constructor", this.classStack.peek().className), astNode);
        }
    }

    private boolean isConstructor(AstNode astNode) {
        return this.isInClass && astNode.is(FlexGrammar.FUNCTION_DEF) && Function.isConstructor(astNode, this.classStack.peek().className);
    }

    private boolean isCallToDispatchEventInConstructor(AstNode astNode) {
        return this.isInClass && this.classStack.peek().isInConstructor && astNode.is(FlexGrammar.PRIMARY_EXPR) && ConstructorCallsDispatchEventCheck.isCallToDispatchEvent(astNode);
    }

    private static boolean isCallToDispatchEvent(AstNode primaryExpr) {
        return "dispatchEvent".equals(primaryExpr.getTokenValue()) && primaryExpr.getNextAstNode().is(FlexGrammar.ARGUMENTS) && primaryExpr.getNextAstNode().getFirstChild(FlexGrammar.LIST_EXPRESSION) != null;
    }

    @Override
    public void leaveNode(AstNode astNode) {
        if (this.isInClass && this.classStack.peek().isInConstructor && astNode.is(FlexGrammar.FUNCTION_DEF)) {
            this.classStack.peek().isInConstructor = false;
        } else if (this.isInClass && astNode.is(FlexGrammar.CLASS_DEF)) {
            this.classStack.pop();
            this.isInClass = !this.classStack.isEmpty();
        }
    }

    private static class ClassState {
        String className;
        boolean isInConstructor;

        public ClassState(String className) {
            this.className = className;
        }
    }
}

