/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.slang.checks;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.sonar.check.Rule;
import org.sonarsource.analyzer.commons.TokenLocation;
import org.sonarsource.slang.api.TextPointer;
import org.sonarsource.slang.api.TopLevelTree;
import org.sonarsource.slang.checks.api.InitContext;
import org.sonarsource.slang.checks.api.SlangCheck;
import org.sonarsource.slang.impl.TextPointerImpl;
import org.sonarsource.slang.impl.TextRangeImpl;

@Rule(key="S1135")
public class TodoCommentCheck
implements SlangCheck {
    private final Pattern todoPattern = Pattern.compile("(?i)(^|[[^\\p{L}]&&\\D])(todo)($|[[^\\p{L}]&&\\D])");

    @Override
    public void initialize(InitContext init) {
        init.register(TopLevelTree.class, (ctx, tree) -> tree.allComments().forEach(comment -> {
            Matcher matcher = this.todoPattern.matcher(comment.text());
            if (matcher.find()) {
                TextPointer start = comment.textRange().start();
                TokenLocation location = new TokenLocation(start.line(), start.lineOffset(), comment.text().substring(0, matcher.start(2)));
                TextRangeImpl todoRange = new TextRangeImpl(new TextPointerImpl(location.endLine(), location.endLineOffset()), new TextPointerImpl(location.endLine(), location.endLineOffset() + 4));
                ctx.reportIssue(todoRange, "Complete the task associated to this TODO comment.");
            }
        }));
    }
}

