/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.slang.checks;

import java.util.List;
import org.sonar.check.Rule;
import org.sonarsource.slang.api.BlockTree;
import org.sonarsource.slang.api.HasKeyword;
import org.sonarsource.slang.api.JumpTree;
import org.sonarsource.slang.api.ReturnTree;
import org.sonarsource.slang.api.ThrowTree;
import org.sonarsource.slang.api.Tree;
import org.sonarsource.slang.checks.api.CheckContext;
import org.sonarsource.slang.checks.api.InitContext;
import org.sonarsource.slang.checks.api.SlangCheck;

@Rule(key="S1763")
public class CodeAfterJumpCheck
implements SlangCheck {
    private static final String MESSAGE = "Refactor this piece of code to not have any dead code after this \"%s\".";

    @Override
    public void initialize(InitContext init) {
        init.register(BlockTree.class, (ctx, blockTree) -> this.checkStatements((CheckContext)ctx, blockTree.statementOrExpressions()));
    }

    protected boolean isValidAfterJump(Tree tree) {
        return false;
    }

    protected boolean shouldIgnore(Tree tree) {
        return false;
    }

    private void checkStatements(CheckContext ctx, List<Tree> statementsOrExpressions) {
        if (statementsOrExpressions.size() < 2) {
            return;
        }
        int index = 0;
        while (index < statementsOrExpressions.size() - 1) {
            Tree current = statementsOrExpressions.get(index);
            Tree next = statementsOrExpressions.get(++index);
            while (index < statementsOrExpressions.size() && this.shouldIgnore(next)) {
                next = statementsOrExpressions.get(index);
                ++index;
            }
            if (!CodeAfterJumpCheck.isJump(current) || this.shouldIgnore(next) || this.isValidAfterJump(next)) continue;
            ctx.reportIssue(current, String.format(MESSAGE, ((HasKeyword)((Object)current)).keyword().text()));
        }
    }

    private static boolean isJump(Tree tree) {
        return tree instanceof JumpTree || tree instanceof ReturnTree || tree instanceof ThrowTree;
    }
}

