/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.terraform.checks.azure.helper;

import java.util.function.Predicate;
import java.util.regex.Pattern;
import org.sonar.iac.common.checks.TextUtils;
import org.sonar.iac.terraform.api.tree.AttributeAccessTree;
import org.sonar.iac.terraform.api.tree.ExpressionTree;
import org.sonar.iac.terraform.api.tree.LiteralExprTree;
import org.sonar.iac.terraform.api.tree.TemplateExpressionTree;
import org.sonar.iac.terraform.api.tree.TemplateInterpolationTree;
import org.sonar.iac.terraform.api.tree.TerraformTree;
import org.sonar.iac.terraform.checks.utils.TerraformUtils;

public class RoleScopeHelper {
    public static final String REFERENCE_SUBSCRIPTION_SCOPE_PATTERN = "data\\.azurerm_subscription\\.[^.]*(primary|current)[^.]*\\.id";
    public static final String PLAIN_SUBSCRIPTION_SCOPE_PATTERN = "^/subscriptions/[^/]+/?$";
    public static final String REFERENCE_MANAGEMENT_GROUP_SCOPE_PATTERN = "data\\.azurerm_management_group\\.[^.]*(parent|root)[^.]*\\.id";
    public static final String PLAIN_MANAGEMENT_GROUP_SCOPE_PATTERN = "^/providers/microsoft\\.management/.+";

    private RoleScopeHelper() {
    }

    public static Predicate<String> matchPredicate(String pattern) {
        return s -> Pattern.matches(pattern, s);
    }

    public static boolean isSensitiveScope(ExpressionTree scope, Predicate<String> referenceScopePredicate, Predicate<String> plainScopePredicate) {
        if (scope.is(TerraformTree.Kind.ATTRIBUTE_ACCESS)) {
            return TerraformUtils.attributeAccessMatches(scope, referenceScopePredicate).isTrue();
        }
        if (scope.is(TerraformTree.Kind.TEMPLATE_EXPRESSION)) {
            return !RoleScopeHelper.isLimitedToResourceGroup((TemplateExpressionTree)scope) && RoleScopeHelper.containsSensitiveInterpolations((TemplateExpressionTree)scope, referenceScopePredicate);
        }
        return TextUtils.matchesValue(scope, plainScopePredicate).isTrue();
    }

    private static boolean containsSensitiveInterpolations(TemplateExpressionTree scope, Predicate<String> referenceScopePredicate) {
        return scope.parts().stream().filter(TemplateInterpolationTree.class::isInstance).map(interpolation -> ((TemplateInterpolationTree)interpolation).expression()).filter(AttributeAccessTree.class::isInstance).map(AttributeAccessTree.class::cast).anyMatch(interpolation -> TerraformUtils.attributeAccessMatches(interpolation, referenceScopePredicate).isTrue());
    }

    private static boolean isLimitedToResourceGroup(TemplateExpressionTree scope) {
        return scope.parts().stream().filter(LiteralExprTree.class::isInstance).anyMatch(part -> TextUtils.matchesValue(part, s -> s.contains("resourceGroups")).isTrue());
    }
}

