/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.terraform.checks.azure;

import java.util.function.Predicate;
import org.sonar.check.Rule;
import org.sonar.iac.common.api.checks.CheckContext;
import org.sonar.iac.common.api.tree.HasTextRange;
import org.sonar.iac.common.checks.PropertyUtils;
import org.sonar.iac.terraform.api.tree.AttributeTree;
import org.sonar.iac.terraform.api.tree.BlockTree;
import org.sonar.iac.terraform.checks.AbstractResourceCheck;
import org.sonar.iac.terraform.checks.azure.helper.RoleScopeHelper;

@Rule(key="S6387")
public class SubscriptionRoleAssignmentCheck
extends AbstractResourceCheck {
    private static final String SUBSCRIPTION_MESSAGE = "Make sure assigning this role with a Subscription scope is safe here.";
    private static final String MANAGEMENT_GROUP_MESSAGE = "Make sure assigning this role with a Management Group scope is safe here.";
    private static final Predicate<String> REFERENCE_SUBSCRIPTION_SCOPE_PREDICATE = RoleScopeHelper.matchPredicate("data\\.azurerm_subscription\\.[^.]*(primary|current)[^.]*\\.id");
    private static final Predicate<String> REFERENCE_MANAGEMENT_GROUP_SCOPE_PREDICATE = RoleScopeHelper.matchPredicate("data\\.azurerm_management_group\\.[^.]*(parent|root)[^.]*\\.id");
    private static final Predicate<String> PLAIN_SUBSCRIPTION_SCOPE_PREDICATE = RoleScopeHelper.matchPredicate("^/subscriptions/[^/]+/?$");
    private static final Predicate<String> PLAIN_MANAGEMENT_GROUP_SCOPE_PREDICATE = RoleScopeHelper.matchPredicate("^/providers/microsoft\\.management/.+");

    @Override
    protected void registerResourceChecks() {
        this.register(SubscriptionRoleAssignmentCheck::checkRoleAssignment, "azurerm_role_assignment");
    }

    private static void checkRoleAssignment(CheckContext ctx, BlockTree resource) {
        PropertyUtils.get(resource, "scope", AttributeTree.class).ifPresent(scope -> {
            if (RoleScopeHelper.isSensitiveScope(scope.value(), REFERENCE_SUBSCRIPTION_SCOPE_PREDICATE, PLAIN_SUBSCRIPTION_SCOPE_PREDICATE)) {
                ctx.reportIssue((HasTextRange)scope, SUBSCRIPTION_MESSAGE);
            } else if (RoleScopeHelper.isSensitiveScope(scope.value(), REFERENCE_MANAGEMENT_GROUP_SCOPE_PREDICATE, PLAIN_MANAGEMENT_GROUP_SCOPE_PREDICATE)) {
                ctx.reportIssue((HasTextRange)scope, MANAGEMENT_GROUP_MESSAGE);
            }
        });
    }
}

