/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.terraform.checks.azure;

import org.sonar.check.Rule;
import org.sonar.iac.common.api.checks.CheckContext;
import org.sonar.iac.common.api.checks.SecondaryLocation;
import org.sonar.iac.common.api.tree.HasTextRange;
import org.sonar.iac.common.checks.PropertyUtils;
import org.sonar.iac.common.checks.TextUtils;
import org.sonar.iac.terraform.api.tree.AttributeTree;
import org.sonar.iac.terraform.api.tree.BlockTree;
import org.sonar.iac.terraform.checks.AbstractResourceCheck;

@Rule(key="S6383")
public class RoleBasedAccessControlCheck
extends AbstractResourceCheck {
    private static final String MISSING_MESSAGE = "Omitting '%s' disables role-based access control for this resource. Make sure it is safe here.";
    private static final String DISABLED_MESSAGE = "Make sure that disabling role-based access control is safe here.";

    @Override
    protected void registerResourceChecks() {
        this.register(RoleBasedAccessControlCheck::checkKubernetesCluster, "azurerm_kubernetes_cluster");
        this.register(RoleBasedAccessControlCheck::checkKeyVault, "azurerm_key_vault");
    }

    private static void checkKubernetesCluster(CheckContext ctx, BlockTree resource) {
        PropertyUtils.get(resource, "role_based_access_control", BlockTree.class).ifPresentOrElse(rbac -> RoleBasedAccessControlCheck.checkRoleBasedAccessControl(ctx, rbac), () -> RoleBasedAccessControlCheck.reportResource(ctx, resource, String.format(MISSING_MESSAGE, "role_based_access_control")));
    }

    private static void checkRoleBasedAccessControl(CheckContext ctx, BlockTree rbac) {
        PropertyUtils.get(rbac, "enabled", AttributeTree.class).filter(attr -> TextUtils.isValueFalse(attr.value())).ifPresentOrElse(attr -> ctx.reportIssue((HasTextRange)attr, DISABLED_MESSAGE), () -> RoleBasedAccessControlCheck.checkAzureActiveDirectory(ctx, rbac));
    }

    private static void checkAzureActiveDirectory(CheckContext ctx, BlockTree rbac) {
        PropertyUtils.get(rbac, "azure_active_directory", BlockTree.class).ifPresent(activeDirectory -> PropertyUtils.get(activeDirectory, "managed", AttributeTree.class).filter(managed -> TextUtils.isValueTrue(managed.value())).ifPresent(managed -> RoleBasedAccessControlCheck.checkRbacEnabled(ctx, activeDirectory, managed)));
    }

    private static void checkRbacEnabled(CheckContext ctx, BlockTree activeDirectory, AttributeTree managed) {
        PropertyUtils.get(activeDirectory, "azure_rbac_enabled", AttributeTree.class).ifPresentOrElse(rbacEnabled -> RoleBasedAccessControlCheck.reportOnFalse(ctx, rbacEnabled, DISABLED_MESSAGE, new SecondaryLocation[0]), () -> ctx.reportIssue(managed, String.format(MISSING_MESSAGE, "azure_rbac_enabled")));
    }

    private static void checkKeyVault(CheckContext ctx, BlockTree resource) {
        PropertyUtils.get(resource, "enable_rbac_authorization", AttributeTree.class).ifPresentOrElse(rbacAuthorization -> RoleBasedAccessControlCheck.reportOnFalse(ctx, rbacAuthorization, DISABLED_MESSAGE, new SecondaryLocation[0]), () -> RoleBasedAccessControlCheck.reportResource(ctx, resource, String.format(MISSING_MESSAGE, "enable_rbac_authorization")));
    }
}

