/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.terraform.checks.azure;

import java.util.List;
import java.util.function.Consumer;
import org.sonar.iac.common.api.checks.SecondaryLocation;
import org.sonar.iac.terraform.checks.ResourceVisitor;

public class AzureWeakSSLProtocolCheckPart
extends ResourceVisitor {
    private static final String STRONG_SSL_PROTOCOL = "TLS1_2";

    @Override
    protected void registerResourceConsumer() {
        this.register(List.of("azurerm_postgresql_server", "azurerm_mysql_server"), AzureWeakSSLProtocolCheckPart.checkSSLProtocol("ssl_minimal_tls_version_enforced"));
        this.register("azurerm_storage_account", AzureWeakSSLProtocolCheckPart.checkSSLProtocol("min_tls_version"));
    }

    private static Consumer<ResourceVisitor.Resource> checkSSLProtocol(String protocolAttribute) {
        return resource -> resource.attribute(protocolAttribute).reportIfValueDoesNotMatch(STRONG_SSL_PROTOCOL, "Change this configuration to use a stronger protocol.", new SecondaryLocation[0]).reportIfAbsence("Omitting %s disables traffic encryption. Make sure it is safe here.");
    }
}

