/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.terraform.checks.azure;

import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import org.sonar.iac.common.api.checks.SecondaryLocation;
import org.sonar.iac.common.checks.TextUtils;
import org.sonar.iac.terraform.api.tree.ExpressionTree;
import org.sonar.iac.terraform.checks.ResourceVisitor;
import org.sonar.iac.terraform.checks.utils.TerraformUtils;

public class AzurePublicNetworkAccessCheckPart
extends ResourceVisitor {
    private static final String OMITTED_MESSAGE = "Omitting %s allows network access from the Internet. Make sure it is safe here.";
    private static final String NETWORK_ACCESS_MESSAGE = "Make sure allowing public network access is safe here.";

    @Override
    protected void registerResourceConsumer() {
        this.register(List.of("azurerm_batch_account", "azurerm_cognitive_account", "azurerm_container_registry", "azurerm_cosmosdb_account", "azurerm_databricks_workspace", "azurerm_eventgrid_domain", "azurerm_eventgrid_topic", "azurerm_healthcare_service", "azurerm_iothub", "azurerm_machine_learning_workspace", "azurerm_managed_disk", "azurerm_mariadb_server", "azurerm_mssql_server", "azurerm_mysql_server", "azurerm_postgresql_server", "azurerm_redis_cache", "azurerm_search_service", "azurerm_synapse_workspace"), this.checkEnabledPublicIp("public_network_access_enabled"));
        this.register(List.of("azurerm_data_factory", "azurerm_purview_account"), this.checkEnabledPublicIp("public_network_enabled"));
        this.register("azurerm_application_gateway", this.checkPublicIpConfiguration("frontend_ip_configuration"));
        this.register("azurerm_network_interface", this.checkPublicIpConfiguration("ip_configuration"));
        this.register(List.of("azurerm_dev_test_linux_virtual_machine", "azurerm_dev_test_windows_virtual_machine"), (ResourceVisitor.Resource resource) -> resource.attribute("disallow_public_ip_address").reportIfFalse(NETWORK_ACCESS_MESSAGE, new SecondaryLocation[0]).reportIfAbsence(OMITTED_MESSAGE));
        this.register("azurerm_dev_test_virtual_network", (ResourceVisitor.Resource resource) -> resource.block("subnet").ifPresent(subnet -> subnet.attribute("use_public_ip_address").reportIfValueDoesNotMatch("Deny", NETWORK_ACCESS_MESSAGE, new SecondaryLocation[0])));
        this.register("azurerm_kubernetes_cluster_node_pool", (ResourceVisitor.Resource resource) -> resource.attribute("enable_node_public_ip").reportIfTrue(NETWORK_ACCESS_MESSAGE, new SecondaryLocation[0]));
        this.register("azurerm_application_insights", (ResourceVisitor.Resource resource) -> Set.of("internet_ingestion_enabled", "internet_query_enabled").forEach(attribute -> resource.attribute((String)attribute).reportIfTrue(NETWORK_ACCESS_MESSAGE, new SecondaryLocation[0]).reportIfAbsence(OMITTED_MESSAGE)));
        this.register("azurerm_sql_managed_instance", (ResourceVisitor.Resource resource) -> resource.attribute("public_data_endpoint_enabled").reportIfTrue(NETWORK_ACCESS_MESSAGE, new SecondaryLocation[0]));
        this.register("azurerm_kubernetes_cluster", (ResourceVisitor.Resource resource) -> {
            resource.block("default_node_pool").ifPresent(defaultNodePool -> defaultNodePool.attribute("enable_node_public_ip").reportIfTrue(NETWORK_ACCESS_MESSAGE, new SecondaryLocation[0]));
            resource.list("api_server_authorized_ip_ranges").reportItemsWhichMatch(ipAddress -> AzurePublicNetworkAccessCheckPart.isPublicIpAddress(ipAddress), NETWORK_ACCESS_MESSAGE, new SecondaryLocation[0]);
        });
    }

    private Consumer<ResourceVisitor.Resource> checkEnabledPublicIp(String propertyName) {
        return resource -> resource.attribute(propertyName).reportIfTrue(NETWORK_ACCESS_MESSAGE, new SecondaryLocation[0]).reportIfAbsence(OMITTED_MESSAGE);
    }

    private Consumer<ResourceVisitor.Resource> checkPublicIpConfiguration(String propertyName) {
        return resource -> resource.blocks(propertyName).forEach(block -> block.attribute("public_ip_address_id").reportIfValueMatches(e -> TerraformUtils.attributeAccessMatches(e, s -> s.startsWith("azurerm_public_ip")).isTrue(), NETWORK_ACCESS_MESSAGE, new SecondaryLocation[0]));
    }

    private static boolean isPublicIpAddress(ExpressionTree ipAddress) {
        return TextUtils.matchesValue(ipAddress, s -> !s.startsWith("10.") && !s.startsWith("172.16.") && !s.startsWith("192.168.") && !s.equals("0.0.0.0/32")).isTrue();
    }
}

