/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.terraform.checks.aws;

import org.sonar.iac.common.api.checks.CheckContext;
import org.sonar.iac.common.api.checks.SecondaryLocation;
import org.sonar.iac.common.api.tree.HasTextRange;
import org.sonar.iac.common.checks.PropertyUtils;
import org.sonar.iac.terraform.api.tree.AttributeTree;
import org.sonar.iac.terraform.api.tree.BlockTree;
import org.sonar.iac.terraform.checks.AbstractResourceCheck;

public class AwsPublicNetworkAccessCheckPart
extends AbstractResourceCheck {
    private static final String MESSAGE = "Make sure that using public IP address is safe here.";
    private static final String SECONDARY_INSTANCE_MESSAGE = "Related instance";
    private static final String SECONDARY_TEMPLATE_MESSAGE = "Related template";

    @Override
    protected void registerResourceChecks() {
        this.register(AwsPublicNetworkAccessCheckPart::checkDMSReplicationInstance, "aws_dms_replication_instance");
        this.register(AwsPublicNetworkAccessCheckPart::checkEC2Instance, "aws_instance");
        this.register(AwsPublicNetworkAccessCheckPart::checkEC2LaunchTemplate, "aws_launch_template");
    }

    private static void checkDMSReplicationInstance(CheckContext ctx, BlockTree resource) {
        PropertyUtils.get(resource, "publicly_accessible", AttributeTree.class).ifPresentOrElse(publiclyAccessible -> AwsPublicNetworkAccessCheckPart.reportOnTrue(ctx, publiclyAccessible, MESSAGE, new SecondaryLocation(resource.labels().get(0), SECONDARY_INSTANCE_MESSAGE)), () -> AwsPublicNetworkAccessCheckPart.reportResource(ctx, resource, MESSAGE));
    }

    private static void checkEC2Instance(CheckContext ctx, BlockTree resource) {
        PropertyUtils.get(resource, "associate_public_ip_address", AttributeTree.class).ifPresentOrElse(publiclyAccessible -> AwsPublicNetworkAccessCheckPart.reportOnTrue(ctx, publiclyAccessible, MESSAGE, new SecondaryLocation(resource.labels().get(0), SECONDARY_INSTANCE_MESSAGE)), () -> AwsPublicNetworkAccessCheckPart.reportResource(ctx, resource, MESSAGE));
    }

    private static void checkEC2LaunchTemplate(CheckContext ctx, BlockTree resource) {
        PropertyUtils.get(resource, "network_interfaces", BlockTree.class).ifPresentOrElse(networkInterfaces -> AwsPublicNetworkAccessCheckPart.checkNetworkInterfaces(ctx, networkInterfaces, resource), () -> AwsPublicNetworkAccessCheckPart.reportResource(ctx, resource, MESSAGE));
    }

    private static void checkNetworkInterfaces(CheckContext ctx, BlockTree networkInterfaces, BlockTree resource) {
        SecondaryLocation resourceAsSecondary = new SecondaryLocation(resource.labels().get(0), SECONDARY_TEMPLATE_MESSAGE);
        PropertyUtils.get(networkInterfaces, "associate_public_ip_address", AttributeTree.class).ifPresentOrElse(associatePublicIpAddress -> AwsPublicNetworkAccessCheckPart.reportOnTrue(ctx, associatePublicIpAddress, MESSAGE, resourceAsSecondary), () -> ctx.reportIssue((HasTextRange)networkInterfaces.key(), MESSAGE, resourceAsSecondary));
    }
}

