/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.terraform.checks;

import java.util.List;
import org.sonar.check.Rule;
import org.sonar.iac.common.api.checks.CheckContext;
import org.sonar.iac.common.api.checks.SecondaryLocation;
import org.sonar.iac.common.api.tree.HasTextRange;
import org.sonar.iac.common.checks.PropertyUtils;
import org.sonar.iac.terraform.api.tree.AttributeTree;
import org.sonar.iac.terraform.api.tree.BlockTree;
import org.sonar.iac.terraform.api.tree.LabelTree;
import org.sonar.iac.terraform.checks.AbstractResourceCheck;

@Rule(key="S6275")
public class UnencryptedEbsVolumeCheck
extends AbstractResourceCheck {
    private static final String[] PROPERTIES = new String[]{"root_block_device", "ebs_block_device"};
    private static final String MESSAGE = "Make sure that using unencrypted volumes is safe here.";

    @Override
    protected void registerResourceChecks() {
        this.register((ctx, resource) -> UnencryptedEbsVolumeCheck.checkEncrypted(ctx, resource, "enabled", true), "aws_ebs_encryption_by_default");
        this.register((ctx, resource) -> UnencryptedEbsVolumeCheck.checkEncrypted(ctx, resource, "encrypted", false), "aws_ebs_volume");
        this.register(UnencryptedEbsVolumeCheck::checkEncryptionProperties, "aws_launch_configuration");
    }

    private static void checkEncryptionProperties(CheckContext ctx, BlockTree resource) {
        for (String propertyName : PROPERTIES) {
            PropertyUtils.get(resource, propertyName, BlockTree.class).ifPresent(propertyTree -> UnencryptedEbsVolumeCheck.checkEncrypted(ctx, propertyTree, "encrypted", false));
        }
    }

    private static void checkEncrypted(CheckContext ctx, BlockTree tree, String key, boolean secureByDefault) {
        PropertyUtils.get(tree, key, AttributeTree.class).ifPresentOrElse(p -> UnencryptedEbsVolumeCheck.reportOnFalse(ctx, p, MESSAGE, new SecondaryLocation[0]), () -> UnencryptedEbsVolumeCheck.reportIfNotSecureByDefault(ctx, tree, secureByDefault));
    }

    private static void reportIfNotSecureByDefault(CheckContext ctx, BlockTree tree, boolean secureByDefault) {
        if (!secureByDefault) {
            List<LabelTree> labels = tree.labels();
            ctx.reportIssue(labels.isEmpty() ? tree.key() : (HasTextRange)labels.get(0), MESSAGE);
        }
    }
}

