/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.terraform.checks;

import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.iac.common.api.checks.CheckContext;
import org.sonar.iac.common.api.tree.HasTextRange;
import org.sonar.iac.common.checks.PropertyUtils;
import org.sonar.iac.common.checks.TextUtils;
import org.sonar.iac.terraform.api.tree.AttributeTree;
import org.sonar.iac.terraform.api.tree.BlockTree;
import org.sonar.iac.terraform.checks.AbstractResourceCheck;

@Rule(key="S6364")
public class ShortBackupRetentionCheck
extends AbstractResourceCheck {
    private static final String MESSAGE = "Make sure that defining a short backup retention duration is safe here.";
    private static final int DEFAULT = 7;
    @RuleProperty(key="backup_retention_duration", defaultValue="7")
    int backupRetentionDuration = 7;

    @Override
    protected void checkResource(CheckContext ctx, BlockTree resource) {
        String type = ShortBackupRetentionCheck.getResourceType(resource);
        if ("aws_db_instance".equals(type) && PropertyUtils.isMissing(resource, "source_db_instance_identifier") || "aws_rds_cluster".equals(type)) {
            ShortBackupRetentionCheck.checkBackupRetentionPeriod(ctx, resource, this.backupRetentionDuration);
        }
    }

    private static void checkBackupRetentionPeriod(CheckContext ctx, BlockTree resource, int minPeriod) {
        PropertyUtils.get(resource, "backup_retention_period", AttributeTree.class).ifPresentOrElse(period -> TextUtils.getIntValue(period.value()).filter(currentPeriod -> currentPeriod < minPeriod).ifPresent(currentPeriod -> ctx.reportIssue((HasTextRange)period, MESSAGE)), () -> ShortBackupRetentionCheck.reportResource(ctx, resource, MESSAGE));
    }
}

