/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.terraform.checks;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.sonar.iac.common.api.checks.CheckContext;
import org.sonar.iac.common.api.checks.IacCheck;
import org.sonar.iac.common.api.checks.InitContext;
import org.sonar.iac.common.api.checks.SecondaryLocation;
import org.sonar.iac.common.api.tree.HasTextRange;
import org.sonar.iac.common.checks.PropertyUtils;
import org.sonar.iac.common.checks.TextUtils;
import org.sonar.iac.terraform.api.tree.AttributeTree;
import org.sonar.iac.terraform.api.tree.BlockTree;
import org.sonar.iac.terraform.api.tree.ExpressionTree;
import org.sonar.iac.terraform.api.tree.TerraformTree;
import org.sonar.iac.terraform.api.tree.TupleTree;
import org.sonar.iac.terraform.checks.AbstractResourceCheck;

public abstract class ResourceVisitor
implements IacCheck {
    private final Map<String, List<Consumer<Resource>>> resourceConsumers = new HashMap<String, List<Consumer<Resource>>>();

    @Override
    public void initialize(InitContext init) {
        init.register(BlockTree.class, this::provideResource);
        this.registerResourceConsumer();
    }

    protected abstract void registerResourceConsumer();

    protected void provideResource(CheckContext ctx, BlockTree blockTree) {
        if (AbstractResourceCheck.isResource(blockTree)) {
            Resource resource = new Resource(ctx, blockTree);
            if (this.resourceConsumers.containsKey(resource.type)) {
                this.resourceConsumers.get(resource.type).forEach(consumer -> consumer.accept(resource));
            }
        }
    }

    protected void register(String resourceName, Consumer<Resource> consumer) {
        this.resourceConsumers.computeIfAbsent(resourceName, i -> new ArrayList()).add(consumer);
    }

    protected void register(List<String> resourceNames, Consumer<Resource> consumer) {
        resourceNames.forEach(resourceName -> this.register((String)resourceName, consumer));
    }

    public static abstract class ListProperty
    extends Property {
        private ListProperty(CheckContext ctx, Block block, String name) {
            super(ctx, block, name);
        }

        public void reportItemsWhichMatch(Predicate<ExpressionTree> predicate, String message, SecondaryLocation ... secondaries) {
        }

        static class AbsentListProperty
        extends ListProperty {
            public AbsentListProperty(CheckContext ctx, Block block, String name) {
                super(ctx, block, name);
            }
        }

        static class PresentListProperty
        extends ListProperty {
            private List<ExpressionTree> items;

            public PresentListProperty(CheckContext ctx, Block block, String name, AttributeTree attributeTree) {
                super(ctx, block, name);
                if (!attributeTree.value().is(TerraformTree.Kind.TUPLE)) {
                    throw new IllegalArgumentException("ListProperty is created on an AttributeTree which does not contain a TupleTree");
                }
                this.items = ((TupleTree)attributeTree.value()).elements().trees();
            }

            @Override
            public void reportItemsWhichMatch(Predicate<ExpressionTree> predicate, String message, SecondaryLocation ... secondaries) {
                this.items.stream().filter(predicate).forEach(item -> this.ctx.reportIssue((HasTextRange)item, message, Arrays.asList(secondaries)));
            }
        }
    }

    public static class Attribute
    extends Property {
        @Nullable
        protected final AttributeTree attributeTree;

        public Attribute(CheckContext ctx, Block block, String name, @Nullable AttributeTree attributeTree) {
            super(ctx, block, name);
            this.attributeTree = attributeTree;
        }

        public void value(Consumer<ExpressionTree> consumer) {
        }

        public Attribute reportIfTrue(String message, SecondaryLocation ... secondaries) {
            return this;
        }

        public Attribute reportIfFalse(String message, SecondaryLocation ... secondaries) {
            return this;
        }

        public Attribute reportIfValueDoesNotMatch(String expectedValue, String message, SecondaryLocation ... secondaries) {
            return this;
        }

        public Attribute reportIfValueMatches(String expectedValue, String message, SecondaryLocation ... secondaries) {
            return this;
        }

        public Attribute reportIfValueDoesNotMatch(Predicate<ExpressionTree> expectedPredicate, String message, SecondaryLocation ... secondaries) {
            return this;
        }

        public Attribute reportIfValueMatches(Predicate<ExpressionTree> expectedPredicate, String message, SecondaryLocation ... secondaries) {
            return this;
        }

        public Attribute reportIfAbsence(String message) {
            return this;
        }

        static class PresentAttribute
        extends Attribute {
            public PresentAttribute(CheckContext ctx, Block block, String name, AttributeTree attributeTree) {
                super(ctx, block, name, attributeTree);
            }

            @Override
            public void value(Consumer<ExpressionTree> consumer) {
                consumer.accept(this.attributeTree.value());
            }

            @Override
            public Attribute reportIfTrue(String message, SecondaryLocation ... secondaries) {
                return this.reportIfValueMatches(TextUtils::isValueTrue, message, secondaries);
            }

            @Override
            public Attribute reportIfFalse(String message, SecondaryLocation ... secondaries) {
                return this.reportIfValueMatches(TextUtils::isValueFalse, message, secondaries);
            }

            @Override
            public Attribute reportIfValueDoesNotMatch(String expectedValue, String message, SecondaryLocation ... secondaries) {
                return this.reportIfValueMatches((ExpressionTree value) -> TextUtils.isValue(value, expectedValue).isFalse(), message, secondaries);
            }

            @Override
            public Attribute reportIfValueDoesNotMatch(Predicate<ExpressionTree> expectedPredicate, String message, SecondaryLocation ... secondaries) {
                return this.reportIfValueMatches(expectedPredicate.negate(), message, secondaries);
            }

            @Override
            public Attribute reportIfValueMatches(String expectedValue, String message, SecondaryLocation ... secondaries) {
                return this.reportIfValueMatches((ExpressionTree value) -> TextUtils.isValue(value, expectedValue).isTrue(), message, secondaries);
            }

            @Override
            public Attribute reportIfValueMatches(Predicate<ExpressionTree> expectedPredicate, String message, SecondaryLocation ... secondaries) {
                if (expectedPredicate.test(this.attributeTree.value())) {
                    this.report(message, secondaries);
                }
                return this;
            }

            private void report(String message, SecondaryLocation ... secondaries) {
                this.ctx.reportIssue((HasTextRange)this.attributeTree, message, Arrays.asList(secondaries));
            }
        }

        static class AbsentAttribute
        extends Attribute {
            public AbsentAttribute(CheckContext ctx, Block block, String name) {
                super(ctx, block, name, null);
            }

            @Override
            public Attribute reportIfAbsence(String absenceMessage) {
                this.block.report(String.format(absenceMessage, this.name), new SecondaryLocation[0]);
                return this;
            }
        }
    }

    public static class Property {
        protected final CheckContext ctx;
        protected final Block block;
        protected final String name;

        public Property(CheckContext ctx, Block block, String name) {
            this.ctx = ctx;
            this.block = block;
            this.name = name;
        }
    }

    protected static class Resource
    extends Block {
        private final String type;

        public Resource(CheckContext ctx, BlockTree resourceTree) {
            super(ctx, resourceTree);
            this.type = AbstractResourceCheck.getResourceType(resourceTree);
        }

        @Override
        public void report(String message, SecondaryLocation ... secondaries) {
            this.ctx.reportIssue((HasTextRange)this.blockTree.labels().get(0), message, Arrays.asList(secondaries));
        }
    }

    protected static class Block {
        protected final CheckContext ctx;
        protected final BlockTree blockTree;

        public Block(CheckContext ctx, BlockTree blockTree) {
            this.ctx = ctx;
            this.blockTree = blockTree;
        }

        public CheckContext context() {
            return this.ctx;
        }

        public Attribute attribute(String propertyName) {
            return PropertyUtils.get(this.blockTree, propertyName, AttributeTree.class).map(a -> new Attribute.PresentAttribute(this.ctx, this, propertyName, (AttributeTree)a)).orElse(new Attribute.AbsentAttribute(this.ctx, this, propertyName));
        }

        public ListProperty list(String propertyName) {
            return PropertyUtils.get(this.blockTree, propertyName, AttributeTree.class).filter(attr -> attr.value() instanceof TupleTree).map(attr -> new ListProperty.PresentListProperty(this.ctx, this, propertyName, (AttributeTree)attr)).orElse(new ListProperty.AbsentListProperty(this.ctx, this, propertyName));
        }

        public Optional<Block> block(String propertyName) {
            return PropertyUtils.get(this.blockTree, propertyName, BlockTree.class).map(b -> new Block(this.ctx, (BlockTree)b));
        }

        public Stream<Block> blocks(String propertyName) {
            return PropertyUtils.getAll(this.blockTree, propertyName, BlockTree.class).stream().map(b -> new Block(this.ctx, (BlockTree)b));
        }

        public void report(String message, SecondaryLocation ... secondaries) {
            this.ctx.reportIssue((HasTextRange)this.blockTree.key(), message, Arrays.asList(secondaries));
        }
    }
}

