/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.terraform.checks;

import org.sonar.check.Rule;
import org.sonar.iac.common.api.checks.CheckContext;
import org.sonar.iac.common.checks.PropertyUtils;
import org.sonar.iac.terraform.api.tree.BlockTree;
import org.sonar.iac.terraform.checks.AbstractResourceCheck;

@Rule(key="S6245")
public class DisabledS3EncryptionCheck
extends AbstractResourceCheck {
    private static final String MESSAGE = "Make sure not using server-side encryption is safe here.";

    @Override
    protected void registerResourceChecks() {
        this.register(DisabledS3EncryptionCheck::checkBucket, "aws_s3_bucket");
    }

    private static void checkBucket(CheckContext ctx, BlockTree resource) {
        if (PropertyUtils.isMissing(resource, "server_side_encryption_configuration")) {
            DisabledS3EncryptionCheck.reportResource(ctx, resource, MESSAGE);
        }
    }
}

