/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.terraform.checks;

import org.sonar.check.Rule;
import org.sonar.iac.common.api.checks.CheckContext;
import org.sonar.iac.common.api.checks.SecondaryLocation;
import org.sonar.iac.common.checks.PropertyUtils;
import org.sonar.iac.terraform.api.tree.AttributeTree;
import org.sonar.iac.terraform.api.tree.BlockTree;
import org.sonar.iac.terraform.checks.AbstractResourceCheck;

@Rule(key="S6303")
public class DisabledRDSEncryptionCheck
extends AbstractResourceCheck {
    private static final String MESSAGE = "Make sure that using unencrypted databases is safe here.";
    private static final String SECONDARY_MESSAGE = "Related RDS DBInstance";

    @Override
    protected void registerResourceChecks() {
        this.register(DisabledRDSEncryptionCheck::checkDbInstance, "aws_db_instance");
    }

    private static void checkDbInstance(CheckContext ctx, BlockTree resource) {
        PropertyUtils.get(resource, "storage_encrypted", AttributeTree.class).ifPresentOrElse(encrypted -> DisabledRDSEncryptionCheck.reportOnFalse(ctx, encrypted, MESSAGE, new SecondaryLocation(resource.labels().get(0), SECONDARY_MESSAGE)), () -> DisabledRDSEncryptionCheck.reportResource(ctx, resource, MESSAGE));
    }
}

