/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.common.extension.visitors;

import org.sonar.api.batch.sensor.highlighting.NewHighlighting;
import org.sonar.api.batch.sensor.highlighting.TypeOfText;
import org.sonar.iac.common.api.tree.HasComments;
import org.sonar.iac.common.api.tree.HasTextRange;
import org.sonar.iac.common.api.tree.Tree;
import org.sonar.iac.common.extension.visitors.InputFileContext;
import org.sonar.iac.common.extension.visitors.TreeVisitor;

public abstract class SyntaxHighlightingVisitor
extends TreeVisitor<InputFileContext> {
    private NewHighlighting newHighlighting;

    protected SyntaxHighlightingVisitor() {
        this.register(Tree.class, (ctx, tree) -> {
            if (tree instanceof HasComments) {
                ((HasComments)((Object)tree)).comments().forEach(comment -> this.highlight((HasTextRange)comment, TypeOfText.COMMENT));
            }
        });
        this.languageSpecificHighlighting();
    }

    protected abstract void languageSpecificHighlighting();

    @Override
    protected void before(InputFileContext ctx, Tree root) {
        this.newHighlighting = ctx.sensorContext.newHighlighting().onFile(ctx.inputFile);
    }

    @Override
    protected void after(InputFileContext ctx, Tree root) {
        this.newHighlighting.save();
    }

    protected void highlight(HasTextRange range, TypeOfText typeOfText) {
        this.newHighlighting.highlight(range.textRange(), typeOfText);
    }
}

