/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.cloudformation.checks;

import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import org.sonar.check.Rule;
import org.sonar.iac.cloudformation.api.tree.SequenceTree;
import org.sonar.iac.cloudformation.checks.AbstractResourceCheck;
import org.sonar.iac.common.api.checks.CheckContext;
import org.sonar.iac.common.api.checks.SecondaryLocation;
import org.sonar.iac.common.api.tree.HasTextRange;
import org.sonar.iac.common.api.tree.PropertyTree;
import org.sonar.iac.common.api.tree.Tree;
import org.sonar.iac.common.checks.PropertyUtils;
import org.sonar.iac.common.checks.TextUtils;

@Rule(key="S6329")
public class AssignedPublicIPAddressCheck
extends AbstractResourceCheck {
    private static final String MESSAGE = "Make sure that using public IP address is safe here.";
    private static final String SECONDARY_DMS_MESSAGE = "Related DMS instance";
    private static final String SECONDARY_EC2_INSTANCE_MESSAGE = "Related EC2 instance";
    private static final String SECONDARY_EC2_TEMPLATE_MESSAGE = "Related EC2 template";

    @Override
    protected void checkResource(CheckContext ctx, AbstractResourceCheck.Resource resource) {
        AssignedPublicIPAddressCheck.checkDMSReplicationInstance(ctx, resource);
        AssignedPublicIPAddressCheck.checkEC2Instance(ctx, resource);
        AssignedPublicIPAddressCheck.checkEC2LaunchTemplate(ctx, resource);
    }

    private static void checkDMSReplicationInstance(CheckContext ctx, AbstractResourceCheck.Resource resource) {
        AssignedPublicIPAddressCheck.checkForProperty(ctx, resource, "AWS::DMS::ReplicationInstance", "PubliclyAccessible", TextUtils::isValueTrue, PropertyTree::value, SECONDARY_DMS_MESSAGE);
    }

    private static void checkEC2Instance(CheckContext ctx, AbstractResourceCheck.Resource resource) {
        if (!resource.isType("AWS::EC2::Instance")) {
            return;
        }
        if (!AssignedPublicIPAddressCheck.checkEC2NetworkInterfaces(ctx, resource, resource.properties(), SECONDARY_EC2_INSTANCE_MESSAGE)) {
            ctx.reportIssue(resource.type(), MESSAGE);
        }
    }

    private static void checkEC2LaunchTemplate(CheckContext ctx, AbstractResourceCheck.Resource resource) {
        AssignedPublicIPAddressCheck.checkForProperty(ctx, resource, "AWS::EC2::LaunchTemplate", "LaunchTemplateData", t -> !AssignedPublicIPAddressCheck.checkEC2NetworkInterfaces(ctx, resource, t, SECONDARY_EC2_TEMPLATE_MESSAGE), PropertyTree::key, SECONDARY_EC2_TEMPLATE_MESSAGE);
    }

    private static boolean checkEC2NetworkInterfaces(CheckContext ctx, AbstractResourceCheck.Resource resource, @Nullable Tree tree, String secondaryMessage) {
        Optional<PropertyTree> maybeNetworkInterfaces = PropertyUtils.get(tree, "NetworkInterfaces");
        if (maybeNetworkInterfaces.isPresent()) {
            Optional<PropertyTree> maybeAssociatePublicIpAddress;
            PropertyTree networkInterfaces = maybeNetworkInterfaces.get();
            if (networkInterfaces.value() instanceof SequenceTree && (maybeAssociatePublicIpAddress = ((SequenceTree)networkInterfaces.value()).elements().stream().map(e -> PropertyUtils.get((Tree)e, "AssociatePublicIpAddress")).filter(Optional::isPresent).map(Optional::get).findAny()).isPresent()) {
                PropertyTree associatePublicIpAddress = maybeAssociatePublicIpAddress.get();
                if (TextUtils.isValueTrue(associatePublicIpAddress.value())) {
                    ctx.reportIssue((HasTextRange)associatePublicIpAddress.value(), MESSAGE, new SecondaryLocation(resource.type(), secondaryMessage));
                }
                return true;
            }
            ctx.reportIssue((HasTextRange)networkInterfaces.key(), MESSAGE, new SecondaryLocation(resource.type(), secondaryMessage));
            return true;
        }
        return false;
    }

    private static void checkForProperty(CheckContext ctx, AbstractResourceCheck.Resource resource, String resourceName, String propertyName, Predicate<Tree> propertyTest, Function<PropertyTree, Tree> treeToHighlight, String secondaryMessage) {
        if (!resource.isType(resourceName)) {
            return;
        }
        Optional<PropertyTree> property = PropertyUtils.get((Tree)resource.properties(), propertyName);
        if (property.isPresent()) {
            PropertyTree propertyTree = property.get();
            if (propertyTest.test(propertyTree.value())) {
                ctx.reportIssue((HasTextRange)treeToHighlight.apply(propertyTree), MESSAGE, new SecondaryLocation(resource.type(), secondaryMessage));
            }
        } else {
            ctx.reportIssue(resource.type(), MESSAGE);
        }
    }
}

