/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.html.lex;

import java.io.IOException;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.util.List;
import org.sonar.plugins.html.lex.AbstractTokenizer;
import org.sonar.plugins.html.node.Attribute;
import org.sonar.plugins.html.node.DirectiveNode;
import org.sonar.plugins.html.node.Node;

class DoctypeTokenizer
extends AbstractTokenizer<List<Node>> {
    public DoctypeTokenizer(String startToken, String endToken) {
        super(startToken, endToken);
    }

    @Override
    protected void addNode(List<Node> nodeList, Node node) {
        super.addNode(nodeList, node);
        DoctypeTokenizer.parseToken((DirectiveNode)node);
    }

    private static void parseToken(DirectiveNode node) {
        String code = node.getCode();
        StreamTokenizer tokenizer = new StreamTokenizer(new StringReader(code));
        tokenizer.quoteChar(34);
        try {
            while (tokenizer.nextToken() != -1) {
                if (tokenizer.sval == null) continue;
                if (node.getNodeName() == null) {
                    node.setNodeName(tokenizer.sval);
                    continue;
                }
                node.getAttributes().add(new Attribute(tokenizer.sval));
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    Node createNode() {
        return new DirectiveNode();
    }
}

