/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.html.core;

import com.sonar.sslr.api.TokenType;
import com.sonar.sslr.impl.Lexer;
import com.sonar.sslr.impl.channel.BlackHoleChannel;
import com.sonar.sslr.impl.channel.BomCharacterChannel;
import com.sonar.sslr.impl.channel.IdentifierAndKeywordChannel;
import com.sonar.sslr.impl.channel.RegexpChannelBuilder;
import com.sonar.sslr.impl.channel.UnknownCharacterChannel;
import java.nio.charset.Charset;
import org.sonar.plugins.html.core.HtmlTokenType;

final class HtmlLexer {
    private HtmlLexer() {
    }

    public static Lexer create(Charset charset) {
        return Lexer.builder().withCharset(charset).withFailIfNoChannelToConsumeOneCharacter(true).withChannel(new BomCharacterChannel()).withChannel(new BlackHoleChannel("\\s++")).withChannel(RegexpChannelBuilder.regexp(HtmlTokenType.DOCTYPE, "<!DOCTYPE.*>")).withChannel(RegexpChannelBuilder.regexp(HtmlTokenType.TAG, "</?[:\\w]+>?")).withChannel(RegexpChannelBuilder.regexp(HtmlTokenType.TAG, "/?>")).withChannel(RegexpChannelBuilder.commentRegexp("<%--[\\w\\W]*?%>")).withChannel(RegexpChannelBuilder.commentRegexp("<!--[\\w\\W]*?-->")).withChannel(RegexpChannelBuilder.commentRegexp("/\\*[\\w\\W]*?\\*/")).withChannel(RegexpChannelBuilder.commentRegexp("//[^\n\r]*")).withChannel(RegexpChannelBuilder.regexp(HtmlTokenType.EXPRESSION, "<%[\\w\\W]*?%>")).withChannel(RegexpChannelBuilder.regexp(HtmlTokenType.ATTRIBUTE, "=[\"']{1}[\\w\\W]*?[\"']{1}")).withChannel(RegexpChannelBuilder.regexp(HtmlTokenType.ATTRIBUTE, "=[^\\s'\"=<>`]++")).withChannel(new IdentifierAndKeywordChannel("\\w++", true, new TokenType[][]{new TokenType[0]})).withChannel(new UnknownCharacterChannel()).build();
    }
}

