/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.html.checks.sonar;

import org.apache.commons.lang.StringUtils;
import org.sonar.check.Rule;
import org.sonar.plugins.html.checks.AbstractPageCheck;
import org.sonar.plugins.html.node.TagNode;

@Rule(key="ImgWithoutAltCheck")
public class ImgWithoutAltCheck
extends AbstractPageCheck {
    @Override
    public void startElement(TagNode node) {
        if (ImgWithoutAltCheck.isImgTag(node) && !ImgWithoutAltCheck.hasAltAttribute(node) && !ImgWithoutAltCheck.hasThymeleafAltAttribute(node) || (ImgWithoutAltCheck.isImageInput(node) || ImgWithoutAltCheck.isAreaTag(node)) && ImgWithoutAltCheck.hasInvalidAltAttribute(node)) {
            this.createViolation(node, "Add an \"alt\" attribute to this image.");
        }
    }

    private static boolean isImgTag(TagNode node) {
        return "IMG".equalsIgnoreCase(node.getNodeName());
    }

    private static boolean isImageInput(TagNode node) {
        String type = node.getPropertyValue("TYPE");
        return "INPUT".equalsIgnoreCase(node.getNodeName()) && "IMAGE".equalsIgnoreCase(type);
    }

    private static boolean isAreaTag(TagNode node) {
        return "AREA".equalsIgnoreCase(node.getNodeName());
    }

    private static boolean hasAltAttribute(TagNode node) {
        return node.hasProperty("ALT");
    }

    private static boolean hasInvalidAltAttribute(TagNode node) {
        return !ImgWithoutAltCheck.hasAltAttribute(node) || StringUtils.trim(node.getPropertyValue("ALT")).isEmpty();
    }

    private static boolean hasThymeleafAltAttribute(TagNode node) {
        String thAttrValue = node.getAttribute("th:attr");
        return node.hasProperty("th:alt") || node.hasProperty("th:alt-title") || thAttrValue != null && thAttrValue.contains("alt=");
    }
}

