/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.html.checks.sonar;

import org.sonar.check.Rule;
import org.sonar.plugins.html.checks.AbstractPageCheck;
import org.sonar.plugins.html.node.TagNode;

@Rule(key="FrameWithoutTitleCheck")
public class FrameWithoutTitleCheck
extends AbstractPageCheck {
    @Override
    public void startElement(TagNode node) {
        if (FrameWithoutTitleCheck.isFrame(node) && !node.hasProperty("TITLE")) {
            this.createViolation(node, "Add a \"title\" attribute to this <" + node.getNodeName() + "> tag.");
        }
    }

    private static boolean isFrame(TagNode node) {
        return "FRAME".equalsIgnoreCase(node.getNodeName()) || "IFRAME".equalsIgnoreCase(node.getNodeName());
    }
}

