/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.html.checks.coding;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.plugins.html.checks.AbstractPageCheck;
import org.sonar.plugins.html.node.TagNode;

@Rule(key="MaxLineLengthCheck")
public class MaxLineLengthCheck
extends AbstractPageCheck {
    private static final int DEFAULT_MAX_LINE_LENGTH = 120;
    @RuleProperty(key="maxLength", description="The maximum authorized line length.", defaultValue="120")
    public int maxLength = 120;
    private final Set<Integer> ignoredLines = new HashSet<Integer>();

    @Override
    public void endDocument() {
        List<String> lines = MaxLineLengthCheck.readLines(this.getHtmlSourceCode().inputFile());
        for (int i = 0; i < lines.size(); ++i) {
            int length = lines.get(i).length();
            if (length <= this.maxLength || this.ignoredLines.contains(i + 1)) continue;
            this.createViolation(i + 1, "Split this " + length + " characters long line (which is greater than " + this.maxLength + " authorized).");
        }
        this.ignoredLines.clear();
    }

    @Override
    public void startElement(TagNode node) {
        TagNode nodeParent = node.getParent();
        if ("PATH".equalsIgnoreCase(node.getNodeName()) && nodeParent != null && "SVG".equalsIgnoreCase(nodeParent.getNodeName())) {
            for (int i = node.getStartLinePosition(); i <= node.getEndLinePosition(); ++i) {
                this.ignoredLines.add(i);
            }
        }
    }

    private static List<String> readLines(InputFile file) {
        List<String> list;
        BufferedReader br = new BufferedReader(new StringReader(file.contents()));
        try {
            list = br.lines().collect(Collectors.toList());
        }
        catch (Throwable throwable) {
            try {
                try {
                    br.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new IllegalStateException("Unable to read " + file, e);
            }
        }
        br.close();
        return list;
    }
}

