/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.jacoco;

import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.sensor.Sensor;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.batch.sensor.SensorDescriptor;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.plugins.jacoco.FileLocator;
import org.sonar.plugins.jacoco.ReportImporter;
import org.sonar.plugins.jacoco.ReportPathsProvider;
import org.sonar.plugins.jacoco.XmlReportParser;

public class JacocoSensor
implements Sensor {
    private static final Logger LOG = Loggers.get(JacocoSensor.class);

    public void describe(SensorDescriptor descriptor) {
        descriptor.name("JaCoCo XML Report Importer");
    }

    public void execute(SensorContext context) {
        ReportPathsProvider reportPathsProvider = new ReportPathsProvider(context);
        Iterable inputFiles = context.fileSystem().inputFiles(context.fileSystem().predicates().all());
        FileLocator locator = new FileLocator(inputFiles);
        ReportImporter importer = new ReportImporter(context);
        this.importReports(reportPathsProvider, locator, importer);
    }

    void importReports(ReportPathsProvider reportPathsProvider, FileLocator locator, ReportImporter importer) {
        Collection<Path> reportPaths = reportPathsProvider.getPaths();
        if (reportPaths.isEmpty()) {
            LOG.info("No report imported, no coverage information will be imported by JaCoCo XML Report Importer");
            return;
        }
        LOG.info("Importing {} report(s). Turn your logs in debug mode in order to see the exhaustive list.", (Object)reportPaths.size());
        for (Path reportPath : reportPaths) {
            LOG.debug("Reading report '{}'", (Object)reportPath);
            try {
                this.importReport(new XmlReportParser(reportPath), locator, importer);
            }
            catch (Exception e) {
                LOG.error("Coverage report '{}' could not be read/imported. Error: {}", (Object)reportPath, (Object)e);
            }
        }
    }

    void importReport(XmlReportParser reportParser, FileLocator locator, ReportImporter importer) {
        List<XmlReportParser.SourceFile> sourceFiles = reportParser.parse();
        for (XmlReportParser.SourceFile sourceFile : sourceFiles) {
            InputFile inputFile = locator.getInputFile(sourceFile.packageName(), sourceFile.name());
            if (inputFile == null) continue;
            try {
                importer.importCoverage(sourceFile, inputFile);
            }
            catch (IllegalStateException e) {
                LOG.error("Cannot import coverage information for file '{}', coverage data is invalid. Error: {}", (Object)inputFile, (Object)e);
            }
        }
    }
}

