/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.tree;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.CheckForNull;
import org.sonar.plugins.python.api.tree.ContinueStatement;
import org.sonar.plugins.python.api.tree.Token;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.plugins.python.api.tree.TreeVisitor;
import org.sonar.python.tree.Separators;
import org.sonar.python.tree.SimpleStatement;

public class ContinueStatementImpl
extends SimpleStatement
implements ContinueStatement {
    private final Token continueKeyword;
    private final Separators separators;

    public ContinueStatementImpl(Token continueKeyword, Separators separators) {
        this.continueKeyword = continueKeyword;
        this.separators = separators;
    }

    @Override
    public Token continueKeyword() {
        return this.continueKeyword;
    }

    @Override
    @CheckForNull
    public Token separator() {
        return this.separators.last();
    }

    @Override
    public Tree.Kind getKind() {
        return Tree.Kind.CONTINUE_STMT;
    }

    @Override
    public void accept(TreeVisitor visitor) {
        visitor.visitContinueStatement(this);
    }

    @Override
    public List<Tree> computeChildren() {
        return Stream.of(Collections.singletonList(this.continueKeyword), this.separators.elements()).flatMap(Collection::stream).filter(Objects::nonNull).collect(Collectors.toList());
    }
}

