/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.tree;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.CheckForNull;
import org.sonar.plugins.python.api.tree.AssignmentStatement;
import org.sonar.plugins.python.api.tree.Expression;
import org.sonar.plugins.python.api.tree.ExpressionList;
import org.sonar.plugins.python.api.tree.Token;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.plugins.python.api.tree.TreeVisitor;
import org.sonar.python.tree.Separators;
import org.sonar.python.tree.SimpleStatement;

public class AssignmentStatementImpl
extends SimpleStatement
implements AssignmentStatement {
    private final List<Token> assignTokens;
    private final List<ExpressionList> lhsExpressions;
    private final Expression assignedValue;
    private final Separators separators;

    public AssignmentStatementImpl(List<Token> assignTokens, List<ExpressionList> lhsExpressions, Expression assignedValue, Separators separators) {
        this.assignTokens = assignTokens;
        this.lhsExpressions = lhsExpressions;
        this.assignedValue = assignedValue;
        this.separators = separators;
    }

    @Override
    public Expression assignedValue() {
        return this.assignedValue;
    }

    @Override
    public List<Token> equalTokens() {
        return this.assignTokens;
    }

    @Override
    public List<ExpressionList> lhsExpressions() {
        return this.lhsExpressions;
    }

    @Override
    @CheckForNull
    public Token separator() {
        return this.separators.last();
    }

    @Override
    public void accept(TreeVisitor visitor) {
        visitor.visitAssignmentStatement(this);
    }

    @Override
    public Tree.Kind getKind() {
        return Tree.Kind.ASSIGNMENT_STMT;
    }

    @Override
    public List<Tree> computeChildren() {
        ArrayList<Tree> children = new ArrayList<Tree>();
        int i = 0;
        for (Tree tree : this.lhsExpressions) {
            children.add(tree);
            if (i < this.assignTokens.size()) {
                children.add(this.assignTokens.get(i));
            }
            ++i;
        }
        children.add(this.assignedValue);
        children.addAll(this.separators.elements());
        return children;
    }
}

