/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.index;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.sonar.plugins.python.api.symbols.AmbiguousSymbol;
import org.sonar.plugins.python.api.symbols.ClassSymbol;
import org.sonar.plugins.python.api.symbols.FunctionSymbol;
import org.sonar.plugins.python.api.symbols.Symbol;
import org.sonar.plugins.python.api.types.InferredType;
import org.sonar.python.index.AmbiguousDescriptor;
import org.sonar.python.index.ClassDescriptor;
import org.sonar.python.index.Descriptor;
import org.sonar.python.index.FunctionDescriptor;
import org.sonar.python.index.VariableDescriptor;
import org.sonar.python.semantic.AmbiguousSymbolImpl;
import org.sonar.python.semantic.ClassSymbolImpl;
import org.sonar.python.semantic.FunctionSymbolImpl;
import org.sonar.python.semantic.ProjectLevelSymbolTable;
import org.sonar.python.semantic.SymbolImpl;
import org.sonar.python.semantic.SymbolUtils;
import org.sonar.python.types.DeclaredType;
import org.sonar.python.types.InferredTypes;

public class DescriptorUtils {
    private DescriptorUtils() {
    }

    public static Descriptor descriptor(Symbol symbol) {
        switch (symbol.kind()) {
            case FUNCTION: {
                return DescriptorUtils.functionDescriptor((FunctionSymbol)symbol);
            }
            case CLASS: {
                return DescriptorUtils.classDescriptor((ClassSymbol)symbol);
            }
            case AMBIGUOUS: {
                return DescriptorUtils.ambiguousDescriptor((AmbiguousSymbol)symbol);
            }
        }
        return new VariableDescriptor(symbol.name(), symbol.fullyQualifiedName(), symbol.annotatedTypeName());
    }

    private static ClassDescriptor classDescriptor(ClassSymbol classSymbol) {
        ClassDescriptor.ClassDescriptorBuilder classDescriptor = new ClassDescriptor.ClassDescriptorBuilder().withName(classSymbol.name()).withFullyQualifiedName(classSymbol.fullyQualifiedName()).withMembers(classSymbol.declaredMembers().stream().map(DescriptorUtils::descriptor).collect(Collectors.toList())).withSuperClasses(classSymbol.superClasses().stream().map(Symbol::fullyQualifiedName).filter(Objects::nonNull).collect(Collectors.toList())).withDefinitionLocation(classSymbol.definitionLocation()).withHasMetaClass(((ClassSymbolImpl)classSymbol).hasMetaClass()).withHasSuperClassWithoutDescriptor(((ClassSymbolImpl)classSymbol).hasSuperClassWithoutSymbol() || classSymbol.superClasses().stream().anyMatch(s -> s.fullyQualifiedName() == null)).withMetaclassFQN(((ClassSymbolImpl)classSymbol).metaclassFQN()).withHasDecorators(classSymbol.hasDecorators()).withSupportsGenerics(((ClassSymbolImpl)classSymbol).supportsGenerics());
        return classDescriptor.build();
    }

    private static FunctionDescriptor functionDescriptor(FunctionSymbol functionSymbol) {
        return new FunctionDescriptor.FunctionDescriptorBuilder().withName(functionSymbol.name()).withFullyQualifiedName(functionSymbol.fullyQualifiedName()).withParameters(DescriptorUtils.parameters(functionSymbol.parameters())).withHasDecorators(functionSymbol.hasDecorators()).withDecorators(functionSymbol.decorators()).withIsAsynchronous(functionSymbol.isAsynchronous()).withIsInstanceMethod(functionSymbol.isInstanceMethod()).withAnnotatedReturnTypeName(functionSymbol.annotatedReturnTypeName()).withDefinitionLocation(functionSymbol.definitionLocation()).build();
    }

    private static AmbiguousDescriptor ambiguousDescriptor(AmbiguousSymbol ambiguousSymbol) {
        return DescriptorUtils.ambiguousDescriptor(ambiguousSymbol, null);
    }

    public static AmbiguousDescriptor ambiguousDescriptor(AmbiguousSymbol ambiguousSymbol, @Nullable String overriddenFQN) {
        String fullyQualifiedName = overriddenFQN != null ? overriddenFQN : ambiguousSymbol.fullyQualifiedName();
        Set<Descriptor> alternatives = ambiguousSymbol.alternatives().stream().map(DescriptorUtils::descriptor).collect(Collectors.toSet());
        return new AmbiguousDescriptor(ambiguousSymbol.name(), fullyQualifiedName, alternatives);
    }

    private static List<FunctionDescriptor.Parameter> parameters(List<FunctionSymbol.Parameter> parameters) {
        return parameters.stream().map(parameter -> new FunctionDescriptor.Parameter(parameter.name(), ((FunctionSymbolImpl.ParameterImpl)parameter).annotatedTypeName(), parameter.hasDefaultValue(), parameter.isKeywordOnly(), parameter.isPositionalOnly(), parameter.isPositionalVariadic(), parameter.isKeywordVariadic(), parameter.location())).collect(Collectors.toList());
    }

    public static Symbol symbolFromDescriptor(Descriptor descriptor, ProjectLevelSymbolTable projectLevelSymbolTable, @Nullable String localSymbolName, Map<Descriptor, Symbol> createdSymbolsByDescriptor, Map<String, Symbol> createdSymbolsByFqn) {
        if (createdSymbolsByDescriptor.containsKey(descriptor)) {
            return createdSymbolsByDescriptor.get(descriptor);
        }
        if (descriptor.fullyQualifiedName() != null && createdSymbolsByFqn.containsKey(descriptor.fullyQualifiedName())) {
            return createdSymbolsByFqn.get(descriptor.fullyQualifiedName());
        }
        String symbolName = localSymbolName != null ? localSymbolName : descriptor.name();
        switch (descriptor.kind()) {
            case CLASS: {
                return DescriptorUtils.createClassSymbol(descriptor, projectLevelSymbolTable, createdSymbolsByDescriptor, createdSymbolsByFqn, symbolName);
            }
            case FUNCTION: {
                return DescriptorUtils.createFunctionSymbol((FunctionDescriptor)descriptor, projectLevelSymbolTable, createdSymbolsByDescriptor, createdSymbolsByFqn, symbolName);
            }
            case VARIABLE: {
                return new SymbolImpl(symbolName, descriptor.fullyQualifiedName());
            }
            case AMBIGUOUS: {
                HashSet<Symbol> alternatives = new HashSet<Symbol>();
                AmbiguousSymbolImpl ambiguousSymbol = new AmbiguousSymbolImpl(symbolName, descriptor.fullyQualifiedName(), alternatives);
                createdSymbolsByDescriptor.put(descriptor, ambiguousSymbol);
                alternatives.addAll(((AmbiguousDescriptor)descriptor).alternatives().stream().map(a -> DescriptorUtils.symbolFromDescriptor(a, projectLevelSymbolTable, symbolName, createdSymbolsByDescriptor, createdSymbolsByFqn)).collect(Collectors.toSet()));
                return ambiguousSymbol;
            }
        }
        throw new IllegalStateException(String.format("Error while creating a Symbol from a Descriptor: Unexpected descriptor kind: %s", new Object[]{descriptor.kind()}));
    }

    private static ClassSymbolImpl createClassSymbol(Descriptor descriptor, ProjectLevelSymbolTable projectLevelSymbolTable, Map<Descriptor, Symbol> createdSymbolsByDescriptor, Map<String, Symbol> createdSymbolByFqn, String symbolName) {
        ClassDescriptor classDescriptor = (ClassDescriptor)descriptor;
        ClassSymbolImpl classSymbol = new ClassSymbolImpl((ClassDescriptor)descriptor, symbolName);
        createdSymbolsByDescriptor.put(descriptor, classSymbol);
        createdSymbolByFqn.put(descriptor.fullyQualifiedName(), classSymbol);
        DescriptorUtils.addSuperClasses(classSymbol, classDescriptor, projectLevelSymbolTable, createdSymbolsByDescriptor, createdSymbolByFqn);
        DescriptorUtils.addMembers(classSymbol, classDescriptor, projectLevelSymbolTable, createdSymbolsByDescriptor, createdSymbolByFqn);
        return classSymbol;
    }

    private static void addMembers(ClassSymbolImpl classSymbol, ClassDescriptor classDescriptor, ProjectLevelSymbolTable projectLevelSymbolTable, Map<Descriptor, Symbol> createdSymbolsByDescriptor, Map<String, Symbol> createdSymbolsByFqn) {
        classSymbol.addMembers(classDescriptor.members().stream().map(memberFqn -> DescriptorUtils.symbolFromDescriptor(memberFqn, projectLevelSymbolTable, null, createdSymbolsByDescriptor, createdSymbolsByFqn)).map(member -> {
            if (member instanceof FunctionSymbolImpl) {
                ((FunctionSymbolImpl)member).setOwner(classSymbol);
            }
            return member;
        }).collect(Collectors.toList()));
    }

    private static void addSuperClasses(ClassSymbolImpl classSymbol, ClassDescriptor classDescriptor, ProjectLevelSymbolTable projectLevelSymbolTable, Map<Descriptor, Symbol> createdSymbolsByDescriptor, Map<String, Symbol> createdSymbolsByFqn) {
        classDescriptor.superClasses().stream().map(superClassFqn -> {
            if (createdSymbolsByFqn.containsKey(superClassFqn)) {
                return (Symbol)createdSymbolsByFqn.get(superClassFqn);
            }
            Symbol symbol = projectLevelSymbolTable.getSymbol((String)superClassFqn, null, createdSymbolsByDescriptor, createdSymbolsByFqn);
            symbol = symbol != null ? symbol : SymbolUtils.typeshedSymbolWithFQN(superClassFqn);
            createdSymbolsByFqn.put((String)superClassFqn, symbol);
            return symbol;
        }).forEach(classSymbol::addSuperClass);
    }

    private static FunctionSymbolImpl createFunctionSymbol(FunctionDescriptor functionDescriptor, ProjectLevelSymbolTable projectLevelSymbolTable, Map<Descriptor, Symbol> createdSymbolsByDescriptor, Map<String, Symbol> createdSymbolsByFqn, String symbolName) {
        FunctionSymbolImpl functionSymbol = new FunctionSymbolImpl(functionDescriptor, symbolName);
        DescriptorUtils.addParameters(functionSymbol, functionDescriptor, projectLevelSymbolTable, createdSymbolsByDescriptor, createdSymbolsByFqn);
        return functionSymbol;
    }

    private static void addParameters(FunctionSymbolImpl functionSymbol, FunctionDescriptor functionDescriptor, ProjectLevelSymbolTable projectLevelSymbolTable, Map<Descriptor, Symbol> createdSymbolsByDescriptor, Map<String, Symbol> createdSymbolsByFqn) {
        functionDescriptor.parameters().stream().map(parameterDescriptor -> {
            FunctionSymbolImpl.ParameterImpl parameter = new FunctionSymbolImpl.ParameterImpl((FunctionDescriptor.Parameter)parameterDescriptor);
            DescriptorUtils.setParameterType(parameter, parameterDescriptor.annotatedType(), projectLevelSymbolTable, createdSymbolsByDescriptor, createdSymbolsByFqn);
            return parameter;
        }).forEach(functionSymbol::addParameter);
    }

    private static void setParameterType(FunctionSymbolImpl.ParameterImpl parameter, String annotatedType, ProjectLevelSymbolTable projectLevelSymbolTable, Map<Descriptor, Symbol> createdSymbolsByDescriptor, Map<String, Symbol> createdSymbolsByFqn) {
        InferredType declaredType;
        if (parameter.isKeywordVariadic()) {
            declaredType = InferredTypes.DICT;
        } else if (parameter.isPositionalVariadic()) {
            declaredType = InferredTypes.TUPLE;
        } else {
            Symbol existingSymbol = createdSymbolsByFqn.get(annotatedType);
            Symbol typeSymbol = existingSymbol != null ? existingSymbol : projectLevelSymbolTable.getSymbol(annotatedType, null, createdSymbolsByDescriptor, createdSymbolsByFqn);
            String annotatedTypeName = parameter.annotatedTypeName();
            if (typeSymbol == null && annotatedTypeName != null) {
                typeSymbol = SymbolUtils.typeshedSymbolWithFQN(annotatedTypeName);
            }
            declaredType = typeSymbol == null ? InferredTypes.anyType() : new DeclaredType(typeSymbol, Collections.emptyList());
        }
        parameter.setDeclaredType(declaredType);
    }
}

