/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks.hotspots;

import org.sonar.check.Rule;
import org.sonar.plugins.python.api.PythonSubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionContext;
import org.sonar.plugins.python.api.symbols.Symbol;
import org.sonar.plugins.python.api.tree.ArgList;
import org.sonar.plugins.python.api.tree.ClassDef;
import org.sonar.plugins.python.api.tree.Expression;
import org.sonar.plugins.python.api.tree.HasSymbol;
import org.sonar.plugins.python.api.tree.RegularArgument;
import org.sonar.plugins.python.api.tree.Tree;

@Rule(key="S2257")
public class NonStandardCryptographicAlgorithmCheck
extends PythonSubscriptionCheck {
    private static final String MESSAGE = "Make sure using a non-standard cryptographic algorithm is safe here.";

    @Override
    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.CLASSDEF, NonStandardCryptographicAlgorithmCheck::checkCreatingCustomHasher);
    }

    private static String getQualifiedName(Expression node) {
        if (node instanceof HasSymbol) {
            Symbol symbol = ((HasSymbol)((Object)node)).symbol();
            return symbol != null ? symbol.fullyQualifiedName() : "";
        }
        return "";
    }

    private static void checkCreatingCustomHasher(SubscriptionContext ctx) {
        ClassDef classDef = (ClassDef)ctx.syntaxNode();
        String qualifiedName = NonStandardCryptographicAlgorithmCheck.getQualifiedName(classDef.name());
        if (qualifiedName != null && qualifiedName.startsWith("django.contrib.auth.hashers")) {
            return;
        }
        ArgList argList = classDef.args();
        if (argList != null) {
            argList.arguments().stream().filter(arg -> arg.is(Tree.Kind.REGULAR_ARGUMENT)).map(RegularArgument.class::cast).filter(arg -> "django.contrib.auth.hashers.BasePasswordHasher".equals(NonStandardCryptographicAlgorithmCheck.getQualifiedName(arg.expression()))).forEach(arg -> ctx.addIssue((Tree)arg, MESSAGE));
        }
    }
}

