/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.sonar.plugins.python.api.SubscriptionContext;
import org.sonar.plugins.python.api.tree.Expression;
import org.sonar.plugins.python.api.tree.StringLiteral;
import org.sonar.plugins.python.api.tree.Tree;

public class StringFormat {
    private static final String SYNTAX_ERROR_MESSAGE = "Fix this formatted string's syntax.";
    private static final BiConsumer<SubscriptionContext, Expression> DO_NOTHING_VALIDATOR = (ctx, expr) -> {};
    private static final Pattern PRINTF_PARAMETER_PATTERN = Pattern.compile("%(?<field>(?:\\((?<mapkey>.*?)\\))?(?<flags>[#\\-+0 ]*)?(?<width>[0-9]*|\\*)?(?:\\.(?<precision>[0-9]*|\\*))?(?:[lLH])?(?<type>[diueEfFgGoxXrsac]|%))?");
    private static final Pattern FORMAT_FIELD_PATTERN = Pattern.compile("^(?<name>[^.\\[!:{}]+)?(?:(?:\\.[a-zA-Z0-9_]+)|(?:\\[[^]]+]))*");
    private static final Pattern FORMAT_NUMBER_PATTERN = Pattern.compile("^\\d+$");
    private static final Pattern FORMAT_UNICODE_PATTERN = Pattern.compile("^\\\\N\\{[a-zA-Z0-9-_\\s]*}");
    private static final String FORMAT_VALID_CONVERSION_FLAGS = "rsa";
    private static final String PRINTF_NUMBER_CONVERTERS = "diueEfFgG";
    private static final String PRINTF_INTEGER_CONVERTERS = "oxX";
    private List<ReplacementField> replacementFields;

    private StringFormat(List<ReplacementField> replacementFields) {
        this.replacementFields = replacementFields;
    }

    public List<ReplacementField> replacementFields() {
        return this.replacementFields;
    }

    public long numExpectedPositional() {
        return this.replacementFields.stream().filter(ReplacementField::isPositional).map(ReplacementField::position).distinct().count();
    }

    public long numExpectedArguments() {
        long numNamed = this.replacementFields.stream().filter(ReplacementField::isNamed).map(ReplacementField::name).distinct().count();
        return this.numExpectedPositional() + numNamed;
    }

    public boolean hasPositionalFields() {
        return this.replacementFields.stream().anyMatch(ReplacementField::isPositional);
    }

    public boolean hasNamedFields() {
        return this.replacementFields.stream().anyMatch(ReplacementField::isNamed);
    }

    public static Optional<StringFormat> createFromStrFormatStyle(Consumer<String> issueReporter, String value) {
        return new StrFormatParser(issueReporter, value).parse();
    }

    public static Optional<StringFormat> createFromPrintfStyle(Consumer<String> issueReporter, String value) {
        ArrayList<ReplacementField> result = new ArrayList<ReplacementField>();
        Matcher matcher = PRINTF_PARAMETER_PATTERN.matcher(value);
        int position = 0;
        while (matcher.find()) {
            int currentPos;
            if (matcher.group("field") == null) {
                issueReporter.accept(SYNTAX_ERROR_MESSAGE);
                return Optional.empty();
            }
            String mapKey = matcher.group("mapkey");
            String conversionType = matcher.group("type");
            if (conversionType.equals("%")) continue;
            String width = matcher.group("width");
            String precision = matcher.group("precision");
            if ("*".equals(width)) {
                currentPos = position++;
                result.add(new PositionalField(StringFormat.printfWidthOrPrecisionValidator(), currentPos));
            }
            if ("*".equals(precision)) {
                currentPos = position++;
                result.add(new PositionalField(StringFormat.printfWidthOrPrecisionValidator(), currentPos));
            }
            char conversionTypeChar = conversionType.charAt(0);
            if (mapKey != null) {
                result.add(new NamedField(StringFormat.printfConversionValidator(conversionTypeChar), mapKey));
                continue;
            }
            int currentPos2 = position++;
            result.add(new PositionalField(StringFormat.printfConversionValidator(conversionTypeChar), currentPos2));
        }
        StringFormat format = new StringFormat(result);
        if (format.hasPositionalFields() && format.hasNamedFields()) {
            issueReporter.accept("Use only positional or only named fields, don't mix them.");
            return Optional.empty();
        }
        return Optional.of(format);
    }

    private static BiConsumer<SubscriptionContext, Expression> printfWidthOrPrecisionValidator() {
        return (ctx, expression) -> {
            if (StringFormat.cannotBeOfType(expression, "int")) {
                ctx.addIssue((Tree)expression, "Replace this value with an integer as \"*\" requires.");
            }
        };
    }

    private static BiConsumer<SubscriptionContext, Expression> printfConversionValidator(char conversionType) {
        if (PRINTF_NUMBER_CONVERTERS.indexOf(conversionType) != -1) {
            return (ctx, expression) -> {
                if (StringFormat.cannotBeOfType(expression, "int", "float")) {
                    ctx.addIssue((Tree)expression, String.format("Replace this value with a number as \"%%%c\" requires.", Character.valueOf(conversionType)));
                }
            };
        }
        if (PRINTF_INTEGER_CONVERTERS.indexOf(conversionType) != -1) {
            return (ctx, expression) -> {
                if (StringFormat.cannotBeOfType(expression, "int")) {
                    ctx.addIssue((Tree)expression, String.format("Replace this value with an integer as \"%%%c\" requires.", Character.valueOf(conversionType)));
                }
            };
        }
        if (conversionType == 'c') {
            return (ctx, expression) -> {
                if (StringFormat.cannotBeOfType(expression, "int") && StringFormat.cannotBeSingleCharString(expression)) {
                    ctx.addIssue((Tree)expression, String.format("Replace this value with an integer or a single character string as \"%%%c\" requires.", Character.valueOf(conversionType)));
                }
            };
        }
        return (ctx, expression) -> {};
    }

    private static boolean cannotBeOfType(Expression expression, String ... types) {
        return Arrays.stream(types).noneMatch(type -> expression.type().canBeOrExtend((String)type));
    }

    private static boolean cannotBeSingleCharString(Expression expression) {
        if (!expression.type().canBeOrExtend("str")) {
            return true;
        }
        if (expression.is(Tree.Kind.STRING_LITERAL)) {
            return ((StringLiteral)expression).trimmedQuotesValue().length() != 1;
        }
        return false;
    }

    private static class StrFormatParser {
        private boolean hasManualNumbering = false;
        private boolean hasAutoNumbering = false;
        private int autoNumberingPos = 0;
        private String currentFieldName = null;
        private String nestedFieldName = null;
        private ParseState state = ParseState.INIT;
        private int nesting = 0;
        private List<ReplacementField> result;
        private Consumer<String> issueReporter;
        private String value;
        private Matcher fieldContentMatcher;

        public StrFormatParser(Consumer<String> issueReporter, String value) {
            this.issueReporter = issueReporter;
            this.value = value;
            this.fieldContentMatcher = FORMAT_FIELD_PATTERN.matcher(this.value);
        }

        public Optional<StringFormat> parse() {
            this.result = new ArrayList<ReplacementField>();
            block11: for (int pos = 0; pos < this.value.length(); ++pos) {
                char current = this.value.charAt(pos);
                switch (this.state) {
                    case INIT: {
                        pos = this.parseInitial(current, pos);
                        continue block11;
                    }
                    case LCURLY: {
                        pos = this.parseFieldName(current, pos);
                        continue block11;
                    }
                    case FIELD: {
                        if (this.tryParseField(current)) continue block11;
                        return Optional.empty();
                    }
                    case RCURLY: {
                        if (current != '}') continue block11;
                        this.state = ParseState.INIT;
                        continue block11;
                    }
                    case FLAG: {
                        if (StringFormat.FORMAT_VALID_CONVERSION_FLAGS.indexOf(current) == -1) {
                            this.issueReporter.accept(String.format("Fix this formatted string's syntax; !%c is not a valid conversion flag.", Character.valueOf(current)));
                            return Optional.empty();
                        }
                        this.state = ParseState.FLAG_CHARACTER;
                        continue block11;
                    }
                    case FLAG_CHARACTER: {
                        if (this.tryParseFlagCharacter(current)) continue block11;
                        return Optional.empty();
                    }
                    case FORMAT: {
                        this.parseFormatSpecifier(current);
                        continue block11;
                    }
                    case FORMAT_LCURLY: {
                        pos = this.parseFormatCurly(pos);
                        continue block11;
                    }
                    case FORMAT_FIELD: {
                        if (this.tryParseFormatSpecifierField(current)) continue block11;
                        return Optional.empty();
                    }
                }
            }
            if (!this.checkParserState()) {
                return Optional.empty();
            }
            return Optional.of(new StringFormat(this.result));
        }

        private boolean checkParserState() {
            if (this.nesting != 0 || this.state != ParseState.INIT) {
                this.issueReporter.accept(StringFormat.SYNTAX_ERROR_MESSAGE);
                return false;
            }
            if (this.hasManualNumbering && this.hasAutoNumbering) {
                this.issueReporter.accept("Use only manual or only automatic field numbering, don't mix them.");
                return false;
            }
            return true;
        }

        private boolean tryParseFormatSpecifierField(char current) {
            if (current != '}') {
                this.issueReporter.accept(StringFormat.SYNTAX_ERROR_MESSAGE);
                return false;
            }
            this.result.add(this.createField(this.nestedFieldName));
            --this.nesting;
            this.state = ParseState.FORMAT;
            return true;
        }

        private int parseFormatCurly(int pos) {
            if (this.fieldContentMatcher.region(pos, this.value.length()).find()) {
                this.state = ParseState.FORMAT_FIELD;
                this.nestedFieldName = this.fieldContentMatcher.group("name");
                pos = this.fieldContentMatcher.end() - 1;
            }
            return pos;
        }

        private int parseInitial(char current, int pos) {
            Matcher unicodeMatcher;
            if (current == '{') {
                this.state = ParseState.LCURLY;
            } else if (current == '}') {
                this.state = ParseState.RCURLY;
            } else if (current == '\\' && (unicodeMatcher = FORMAT_UNICODE_PATTERN.matcher(this.value).region(pos, this.value.length())).find()) {
                pos = unicodeMatcher.end() - 1;
            }
            return pos;
        }

        private void parseFormatSpecifier(char current) {
            if (current == '{') {
                ++this.nesting;
                this.state = ParseState.FORMAT_LCURLY;
            } else if (current == '}') {
                this.result.add(this.createField(this.currentFieldName));
                --this.nesting;
                this.state = ParseState.INIT;
            }
        }

        private boolean tryParseFlagCharacter(char current) {
            if (current == ':') {
                this.state = ParseState.FORMAT;
            } else if (current == '}') {
                this.result.add(this.createField(this.currentFieldName));
                --this.nesting;
                this.state = ParseState.INIT;
            } else {
                this.issueReporter.accept(StringFormat.SYNTAX_ERROR_MESSAGE);
                return false;
            }
            return true;
        }

        private boolean tryParseField(char current) {
            if (current == '!') {
                this.state = ParseState.FLAG;
            } else if (current == ':') {
                this.state = ParseState.FORMAT;
            } else if (current == '}') {
                --this.nesting;
                this.result.add(this.createField(this.currentFieldName));
                this.state = ParseState.INIT;
            } else {
                this.issueReporter.accept(StringFormat.SYNTAX_ERROR_MESSAGE);
                return false;
            }
            return true;
        }

        private int parseFieldName(char current, int pos) {
            if (current == '{') {
                this.state = ParseState.INIT;
            } else {
                this.state = ParseState.FIELD;
                ++this.nesting;
                if (this.fieldContentMatcher.region(pos, this.value.length()).find()) {
                    this.currentFieldName = this.fieldContentMatcher.group("name");
                    pos = this.fieldContentMatcher.end() - 1;
                }
            }
            return pos;
        }

        private ReplacementField createField(@Nullable String name) {
            if (name == null) {
                this.hasAutoNumbering = true;
                int currentPos = this.autoNumberingPos++;
                return new PositionalField((BiConsumer<SubscriptionContext, Expression>)DO_NOTHING_VALIDATOR, currentPos);
            }
            if (FORMAT_NUMBER_PATTERN.matcher(name).find()) {
                this.hasManualNumbering = true;
                return new PositionalField((BiConsumer<SubscriptionContext, Expression>)DO_NOTHING_VALIDATOR, Integer.parseInt(name));
            }
            return new NamedField((BiConsumer<SubscriptionContext, Expression>)DO_NOTHING_VALIDATOR, name);
        }
    }

    private static enum ParseState {
        INIT,
        LCURLY,
        RCURLY,
        FIELD,
        FLAG,
        FLAG_CHARACTER,
        FORMAT,
        FORMAT_LCURLY,
        FORMAT_FIELD;

    }

    public static class PositionalField
    extends ReplacementField {
        private int position;

        public PositionalField(BiConsumer<SubscriptionContext, Expression> validator, int position) {
            super(validator);
            this.position = position;
        }

        @Override
        public boolean isNamed() {
            return false;
        }

        @Override
        public boolean isPositional() {
            return true;
        }

        @Override
        public String name() {
            throw new NoSuchElementException();
        }

        @Override
        public int position() {
            return this.position;
        }
    }

    public static class NamedField
    extends ReplacementField {
        private String name;

        public NamedField(BiConsumer<SubscriptionContext, Expression> validator, String name) {
            super(validator);
            this.name = name;
        }

        @Override
        public boolean isNamed() {
            return true;
        }

        @Override
        public boolean isPositional() {
            return false;
        }

        @Override
        public String name() {
            return this.name;
        }

        @Override
        public int position() {
            throw new NoSuchElementException();
        }
    }

    public static abstract class ReplacementField {
        private BiConsumer<SubscriptionContext, Expression> validator;

        private ReplacementField(BiConsumer<SubscriptionContext, Expression> validator) {
            this.validator = validator;
        }

        public abstract boolean isNamed();

        public abstract boolean isPositional();

        public abstract String name();

        public abstract int position();

        public void validateArgument(SubscriptionContext ctx, Expression expression) {
            this.validator.accept(ctx, expression);
        }
    }
}

