/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.python.parser;

import com.ctc.wstx.stax.WstxInputFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.stream.XMLResolver;
import javax.xml.stream.XMLStreamException;
import org.apache.commons.lang.StringUtils;
import org.codehaus.staxmate.SMInputFactory;
import org.codehaus.staxmate.in.SMHierarchicCursor;
import org.sonarsource.analyzer.commons.xml.SafetyFactory;

public class StaxParser {
    private SMInputFactory inf;
    private XmlStreamHandler streamHandler;

    public StaxParser(XmlStreamHandler streamHandler) {
        this.streamHandler = streamHandler;
        WstxInputFactory xmlFactory = (WstxInputFactory)SafetyFactory.createXMLInputFactory();
        xmlFactory.configureForLowMemUsage();
        xmlFactory.getConfig().setUndeclaredEntityResolver(new UndeclaredEntitiesXMLResolver());
        this.inf = new SMInputFactory(xmlFactory);
    }

    public void parse(File xmlFile) throws XMLStreamException {
        try (FileInputStream input = new FileInputStream(xmlFile);){
            this.parse(input);
        }
        catch (IOException e) {
            throw new XMLStreamException(e);
        }
    }

    public void parse(InputStream xmlInput) throws XMLStreamException {
        SMHierarchicCursor rootCursor = this.inf.rootElementCursor(xmlInput);
        try {
            this.streamHandler.stream(rootCursor);
        }
        finally {
            rootCursor.getStreamReader().closeCompletely();
        }
    }

    @FunctionalInterface
    public static interface XmlStreamHandler {
        public void stream(SMHierarchicCursor var1) throws XMLStreamException;
    }

    private static class UndeclaredEntitiesXMLResolver
    implements XMLResolver {
        private UndeclaredEntitiesXMLResolver() {
        }

        @Override
        public Object resolveEntity(String arg0, String arg1, String fileName, String undeclaredEntity) throws XMLStreamException {
            int unicodeCharHexValue;
            String undeclared = undeclaredEntity;
            if (StringUtils.startsWithIgnoreCase(undeclaredEntity, "u") && undeclaredEntity.length() == 5 && Character.isDefined(unicodeCharHexValue = Integer.parseInt(undeclaredEntity.substring(1), 16))) {
                undeclared = new String(new char[]{(char)unicodeCharHexValue});
            }
            return undeclared;
        }
    }
}

