/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.python;

import java.io.IOException;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonarsource.analyzer.commons.ProgressReport;

public abstract class Scanner {
    private static final Logger LOG = Loggers.get(Scanner.class);
    private static final String FAIL_FAST_PROPERTY_NAME = "sonar.internal.analysis.failFast";
    protected final SensorContext context;

    protected Scanner(SensorContext context) {
        this.context = context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(List<InputFile> files, SensorContext context) {
        ProgressReport progressReport = new ProgressReport(this.name() + " progress", TimeUnit.SECONDS.toMillis(10L));
        LOG.info("Starting " + this.name());
        List<String> filenames = files.stream().map(InputFile::toString).collect(Collectors.toList());
        progressReport.start(filenames);
        for (InputFile file : files) {
            if (context.isCancelled()) {
                progressReport.cancel();
                return;
            }
            try {
                this.scanFile(file);
            }
            catch (Exception e) {
                this.processException(e, file);
                if (!context.config().getBoolean(FAIL_FAST_PROPERTY_NAME).orElse(false).booleanValue()) continue;
                throw new IllegalStateException("Exception when analyzing " + file, e);
            }
            finally {
                progressReport.nextFile();
            }
        }
        progressReport.stop();
    }

    protected abstract String name();

    protected abstract void scanFile(InputFile var1) throws IOException;

    protected abstract void processException(Exception var1, InputFile var2);
}

