/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.python;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.RecognitionException;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import org.sonar.api.SonarProduct;
import org.sonar.api.batch.fs.FilePredicates;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.rule.CheckFactory;
import org.sonar.api.batch.sensor.Sensor;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.batch.sensor.SensorDescriptor;
import org.sonar.api.issue.NoSonarFilter;
import org.sonar.api.measures.FileLinesContextFactory;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.plugins.python.PythonChecks;
import org.sonar.plugins.python.PythonHighlighter;
import org.sonar.plugins.python.PythonScanner;
import org.sonar.plugins.python.Scanner;
import org.sonar.plugins.python.SonarQubePythonFile;
import org.sonar.plugins.python.api.ProjectPythonVersion;
import org.sonar.plugins.python.api.PythonCustomRuleRepository;
import org.sonar.plugins.python.api.PythonFile;
import org.sonar.plugins.python.api.PythonVersionUtils;
import org.sonar.plugins.python.api.PythonVisitorContext;
import org.sonar.plugins.python.api.tree.FileInput;
import org.sonar.plugins.python.indexer.PythonIndexer;
import org.sonar.plugins.python.indexer.SonarQubePythonIndexer;
import org.sonar.plugins.python.warnings.AnalysisWarningsWrapper;
import org.sonar.python.checks.CheckList;
import org.sonar.python.parser.PythonParser;
import org.sonar.python.semantic.ProjectLevelSymbolTable;
import org.sonar.python.tree.PythonTreeMaker;
import org.sonarsource.performance.measure.PerformanceMeasure;

public final class PythonSensor
implements Sensor {
    private static final String PERFORMANCE_MEASURE_PROPERTY = "sonar.python.performance.measure";
    private static final String PERFORMANCE_MEASURE_FILE_PATH_PROPERTY = "sonar.python.performance.measure.path";
    private static final String PERFORMANCE_MEASURE_DESTINATION_FILE = "sonar-python-performance-measure.json";
    private final PythonChecks checks;
    private final FileLinesContextFactory fileLinesContextFactory;
    private final NoSonarFilter noSonarFilter;
    private final PythonIndexer indexer;
    private final AnalysisWarningsWrapper analysisWarnings;
    private static final Logger LOG = Loggers.get(PythonSensor.class);
    static final String UNSET_VERSION_WARNING = "Your code is analyzed as compatible with python 2 and 3 by default. This will prevent the detection of issues specific to python 2 or python 3. You can get a more precise analysis by setting a python version in your configuration via the parameter \"sonar.python.version\"";

    public PythonSensor(FileLinesContextFactory fileLinesContextFactory, CheckFactory checkFactory, NoSonarFilter noSonarFilter, AnalysisWarningsWrapper analysisWarnings) {
        this(fileLinesContextFactory, checkFactory, noSonarFilter, null, null, analysisWarnings);
    }

    public PythonSensor(FileLinesContextFactory fileLinesContextFactory, CheckFactory checkFactory, NoSonarFilter noSonarFilter, PythonCustomRuleRepository[] customRuleRepositories, AnalysisWarningsWrapper analysisWarnings) {
        this(fileLinesContextFactory, checkFactory, noSonarFilter, customRuleRepositories, null, analysisWarnings);
    }

    public PythonSensor(FileLinesContextFactory fileLinesContextFactory, CheckFactory checkFactory, NoSonarFilter noSonarFilter, PythonIndexer indexer, AnalysisWarningsWrapper analysisWarnings) {
        this(fileLinesContextFactory, checkFactory, noSonarFilter, null, indexer, analysisWarnings);
    }

    public PythonSensor(FileLinesContextFactory fileLinesContextFactory, CheckFactory checkFactory, NoSonarFilter noSonarFilter, @Nullable PythonCustomRuleRepository[] customRuleRepositories, @Nullable PythonIndexer indexer, AnalysisWarningsWrapper analysisWarnings) {
        this.checks = new PythonChecks(checkFactory).addChecks("python", CheckList.getChecks()).addCustomChecks(customRuleRepositories);
        this.fileLinesContextFactory = fileLinesContextFactory;
        this.noSonarFilter = noSonarFilter;
        this.indexer = indexer;
        this.analysisWarnings = analysisWarnings;
    }

    public void describe(SensorDescriptor descriptor) {
        descriptor.onlyOnLanguage("py").name("Python Sensor").onlyOnFileType(InputFile.Type.MAIN);
    }

    public void execute(SensorContext context) {
        PerformanceMeasure.Duration durationReport = PythonSensor.createPerformanceMeasureReport(context);
        List<InputFile> mainFiles = PythonSensor.getInputFiles(InputFile.Type.MAIN, context);
        List<InputFile> testFiles = PythonSensor.getInputFiles(InputFile.Type.TEST, context);
        Optional pythonVersionParameter = context.config().get("sonar.python.version");
        if (!pythonVersionParameter.isPresent() && context.runtime().getProduct() != SonarProduct.SONARLINT) {
            LOG.warn(UNSET_VERSION_WARNING);
            this.analysisWarnings.addUnique(UNSET_VERSION_WARNING);
        }
        pythonVersionParameter.ifPresent(value -> ProjectPythonVersion.setCurrentVersions(PythonVersionUtils.fromString(value)));
        PythonIndexer pythonIndexer = this.indexer != null ? this.indexer : new SonarQubePythonIndexer(mainFiles);
        PythonScanner scanner = new PythonScanner(context, this.checks, this.fileLinesContextFactory, this.noSonarFilter, pythonIndexer);
        scanner.execute(mainFiles, context);
        durationReport.stop();
        if (!testFiles.isEmpty()) {
            new TestHighlightingScanner(context).execute(testFiles, context);
        }
    }

    private static List<InputFile> getInputFiles(InputFile.Type type, SensorContext context) {
        FilePredicates p = context.fileSystem().predicates();
        Iterable it = context.fileSystem().inputFiles(p.and(p.hasType(type), p.hasLanguage("py")));
        ArrayList list = new ArrayList();
        it.forEach(list::add);
        return Collections.unmodifiableList(list);
    }

    private static PerformanceMeasure.Duration createPerformanceMeasureReport(SensorContext context) {
        return PerformanceMeasure.reportBuilder().activate(context.config().getBoolean(PERFORMANCE_MEASURE_PROPERTY).orElse(Boolean.FALSE)).toFile(context.config().get(PERFORMANCE_MEASURE_FILE_PATH_PROPERTY).filter(path -> !path.isEmpty()).orElseGet(() -> Optional.ofNullable(context.fileSystem().workDir()).filter(File::exists).map(file -> file.toPath().resolve(PERFORMANCE_MEASURE_DESTINATION_FILE).toString()).orElse(null))).appendMeasurementCost().start("PythonSensor");
    }

    private static class TestHighlightingScanner
    extends Scanner {
        private static final Logger LOG = Loggers.get(TestHighlightingScanner.class);
        private final PythonParser parser = PythonParser.create();

        TestHighlightingScanner(SensorContext context) {
            super(context);
        }

        @Override
        protected String name() {
            return "test sources highlighting";
        }

        @Override
        protected void scanFile(InputFile inputFile) throws IOException {
            try {
                PythonFile pythonFile = SonarQubePythonFile.create(inputFile);
                AstNode astNode = this.parser.parse(pythonFile.content());
                FileInput parse = new PythonTreeMaker().fileInput(astNode);
                PythonVisitorContext visitorContext = new PythonVisitorContext(parse, pythonFile, this.context.fileSystem().workDir(), "", ProjectLevelSymbolTable.empty());
                new PythonHighlighter(this.context, inputFile).scanFile(visitorContext);
            }
            catch (RecognitionException e) {
                LOG.error("Unable to parse file: " + inputFile.toString());
                LOG.error(e.getMessage());
            }
        }

        @Override
        protected void processException(Exception e, InputFile file) {
            LOG.warn("Unable to highlight test file: " + file.toString(), (Throwable)e);
        }
    }
}

