/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc2.old;

import java.util.Collection;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc16.SVNCopyClient16;
import org.tmatesoft.svn.core.internal.wc16.SVNMoveClient16;
import org.tmatesoft.svn.core.internal.wc2.compat.SvnCodec;
import org.tmatesoft.svn.core.internal.wc2.old.SvnOldRunner;
import org.tmatesoft.svn.core.wc.ISVNExternalsHandler;
import org.tmatesoft.svn.core.wc.SVNCopySource;
import org.tmatesoft.svn.core.wc2.SvnCopy;
import org.tmatesoft.svn.core.wc2.SvnCopySource;
import org.tmatesoft.svn.core.wc2.SvnTarget;
import org.tmatesoft.svn.util.SVNLogType;

public class SvnOldCopy
extends SvnOldRunner<Void, SvnCopy> {
    @Override
    protected Void run() throws SVNException {
        if (((SvnCopy)this.getOperation()).isDisjoint()) {
            return this.disjointCopy();
        }
        if (((SvnCopy)this.getOperation()).isVirtual()) {
            return this.virtualCopy();
        }
        return this.copy();
    }

    private Void disjointCopy() throws SVNException {
        assert (!((SvnCopy)this.getOperation()).isMove());
        SVNCopyClient16 client = new SVNCopyClient16(((SvnCopy)this.getOperation()).getRepositoryPool(), ((SvnCopy)this.getOperation()).getOptions());
        client.setEventHandler(((SvnCopy)this.getOperation()).getEventHandler());
        client.setCommitHandler(null);
        client.setExternalsHandler(ISVNExternalsHandler.DEFAULT);
        client.setOptions(((SvnCopy)this.getOperation()).getOptions());
        Collection<SvnTarget> targets = ((SvnCopy)this.getOperation()).getTargets();
        for (SvnTarget target : targets) {
            if (target.isURL()) {
                this.throwCannotPerformOnUrl(target, "disjoint", "copy");
            }
            client.doCopy(target.getFile());
        }
        return null;
    }

    private Void virtualCopy() throws SVNException {
        SVNCopySource[] sources;
        SVNMoveClient16 client = new SVNMoveClient16(((SvnCopy)this.getOperation()).getRepositoryPool(), ((SvnCopy)this.getOperation()).getOptions());
        client.setEventHandler(((SvnCopy)this.getOperation()).getEventHandler());
        client.setOptions(((SvnCopy)this.getOperation()).getOptions());
        SvnTarget target = ((SvnCopy)this.getOperation()).getFirstTarget();
        if (target.isURL()) {
            this.throwCannotPerformOnUrl(target, "virtual", ((SvnCopy)this.getOperation()).isMove() ? "move" : "copy");
        }
        for (SVNCopySource source2 : sources = this.getCopySources()) {
            client.doVirtualCopy(source2.getFile(), target.getFile(), ((SvnCopy)this.getOperation()).isMove());
        }
        return null;
    }

    private Void copy() throws SVNException {
        SVNCopyClient16 client = new SVNCopyClient16(((SvnCopy)this.getOperation()).getRepositoryPool(), ((SvnCopy)this.getOperation()).getOptions());
        client.setEventHandler(((SvnCopy)this.getOperation()).getEventHandler());
        client.setCommitHandler(null);
        client.setExternalsHandler(ISVNExternalsHandler.DEFAULT);
        client.setOptions(((SvnCopy)this.getOperation()).getOptions());
        SvnTarget target = ((SvnCopy)this.getOperation()).getFirstTarget();
        SVNCopySource[] sources = this.getCopySources();
        if (target.isURL()) {
            client.doCopy(sources, target.getURL(), ((SvnCopy)this.getOperation()).isMove(), ((SvnCopy)this.getOperation()).isMakeParents(), ((SvnCopy)this.getOperation()).isFailWhenDstExists(), null, null);
        } else {
            client.doCopy(sources, target.getFile(), ((SvnCopy)this.getOperation()).isMove(), ((SvnCopy)this.getOperation()).isMakeParents(), ((SvnCopy)this.getOperation()).isFailWhenDstExists());
        }
        return null;
    }

    private SVNCopySource[] getCopySources() {
        SVNCopySource[] sources = new SVNCopySource[((SvnCopy)this.getOperation()).getSources().size()];
        int i = 0;
        for (SvnCopySource newSource2 : ((SvnCopy)this.getOperation()).getSources()) {
            sources[i] = SvnCodec.copySource(newSource2);
            ++i;
        }
        return sources;
    }

    private void throwCannotPerformOnUrl(SvnTarget target, String kind, String operation) throws SVNException {
        SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.UNSUPPORTED_FEATURE, "Cannot perform ''{0}'' {1}: ''{2}'' is URL", kind, operation, target);
        SVNErrorManager.error(err, SVNLogType.WC);
    }
}

