/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc2.ng;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.tmatesoft.sqljet.core.SqlJetTransactionMode;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.internal.db.SVNSqlJetDb;
import org.tmatesoft.svn.core.internal.db.SVNSqlJetSelectFieldsStatement;
import org.tmatesoft.svn.core.internal.db.SVNSqlJetUpdateStatement;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.internal.wc.SVNTreeConflictUtil;
import org.tmatesoft.svn.core.internal.wc17.SVNWCContext;
import org.tmatesoft.svn.core.internal.wc17.db.SVNWCDb;
import org.tmatesoft.svn.core.internal.wc17.db.SVNWCDbRoot;
import org.tmatesoft.svn.core.internal.wc17.db.SvnWcDbStatementUtil;
import org.tmatesoft.svn.core.internal.wc17.db.statement.SVNWCDbSchema;
import org.tmatesoft.svn.core.internal.wc2.SvnWcGeneration;
import org.tmatesoft.svn.core.internal.wc2.ng.SvnNgOperationRunner;
import org.tmatesoft.svn.core.internal.wc2.ng.SvnNgUpgradeSDb;
import org.tmatesoft.svn.core.wc.SVNConflictDescription;
import org.tmatesoft.svn.core.wc.SVNMergeFileSet;
import org.tmatesoft.svn.core.wc.SVNPropertyConflictDescription;
import org.tmatesoft.svn.core.wc.SVNTextConflictDescription;
import org.tmatesoft.svn.core.wc.SVNTreeConflictDescription;
import org.tmatesoft.svn.core.wc2.SvnUpgrade;

public class SvnNgDowngrade
extends SvnNgOperationRunner<SvnWcGeneration, SvnUpgrade> {
    @Override
    protected SvnWcGeneration run(SVNWCContext context) throws SVNException {
        File localAbsPath = this.getFirstTarget();
        this.downgrade(this.getWcContext(), localAbsPath);
        return SvnWcGeneration.V17;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void downgrade(SVNWCContext context, File localAbsPath) throws SVNException {
        SVNWCDb db = (SVNWCDb)context.getDb();
        SVNWCDb.DirParsedInfo parsed = db.parseDir(localAbsPath, SVNSqlJetDb.Mode.ReadOnly);
        SVNWCDbRoot wcRoot = parsed.wcDbDir.getWCRoot();
        File wcRootAbsPath = wcRoot.getAbsPath();
        SVNSqlJetDb sDb = wcRoot.getSDb();
        sDb.beginTransaction(SqlJetTransactionMode.WRITE);
        try {
            ArrayList<Long> wcIds = new ArrayList<Long>();
            ArrayList<File> paths = new ArrayList<File>();
            this.collectConflicts18(sDb, wcIds, paths);
            for (int i = 0; i < wcIds.size(); ++i) {
                long wcId = wcIds.get(i);
                File childRelPath = paths.get(i);
                File childAbsPath = SVNFileUtil.createFilePath(wcRoot.getAbsPath(), childRelPath);
                List<SVNConflictDescription> conflictDescriptions = db.readConflicts(childAbsPath);
                File conflictOldAbsPath = null;
                File conflictNewAbsPath = null;
                File conflictWorkingAbsPath = null;
                File prejAbsPath = null;
                byte[] treeConflictData = null;
                for (SVNConflictDescription conflictDescription : conflictDescriptions) {
                    SVNMergeFileSet mergeFiles;
                    if (conflictDescription instanceof SVNTextConflictDescription) {
                        SVNTextConflictDescription textConflictDescription = (SVNTextConflictDescription)conflictDescription;
                        mergeFiles = textConflictDescription.getMergeFiles();
                        conflictOldAbsPath = mergeFiles.getBaseFile();
                        conflictWorkingAbsPath = mergeFiles.getLocalFile();
                        conflictNewAbsPath = mergeFiles.getRepositoryFile();
                        continue;
                    }
                    if (conflictDescription instanceof SVNPropertyConflictDescription) {
                        SVNPropertyConflictDescription propertyConflictDescription = (SVNPropertyConflictDescription)conflictDescription;
                        mergeFiles = propertyConflictDescription.getMergeFiles();
                        prejAbsPath = mergeFiles.getRepositoryFile();
                        continue;
                    }
                    if (!(conflictDescription instanceof SVNTreeConflictDescription)) continue;
                    SVNTreeConflictDescription treeConflictDescription = (SVNTreeConflictDescription)conflictDescription;
                    treeConflictData = SVNTreeConflictUtil.getSingleTreeConflictRawData(treeConflictDescription);
                }
                File conflictOldRelPath = conflictOldAbsPath == null ? null : SVNFileUtil.skipAncestor(wcRootAbsPath, conflictOldAbsPath);
                File conflictNewRelPath = conflictNewAbsPath == null ? null : SVNFileUtil.skipAncestor(wcRootAbsPath, conflictNewAbsPath);
                File conflictWorkingRelPath = conflictWorkingAbsPath == null ? null : SVNFileUtil.skipAncestor(wcRootAbsPath, conflictWorkingAbsPath);
                File prejRelPath = prejAbsPath == null ? null : SVNFileUtil.skipAncestor(wcRootAbsPath, prejAbsPath);
                this.downgradeConflict(sDb, wcId, childRelPath, conflictOldRelPath, conflictNewRelPath, conflictWorkingRelPath, prejRelPath, treeConflictData);
            }
            SvnNgUpgradeSDb.setVersion(sDb, 29);
        }
        catch (SVNException e) {
            sDb.rollback();
        }
        finally {
            sDb.commit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void downgradeConflict(SVNSqlJetDb sDb, long wcId, File localAbsPath, File conflictOldRelPath, File conflictNewRelPath, File conflictWorkingRelPath, File prejRelPath, byte[] treeConflictData) throws SVNException {
        DowngradeConflictStatement downgradeConflictStatement = new DowngradeConflictStatement(sDb);
        try {
            downgradeConflictStatement.bindf("isssssb", wcId, localAbsPath, conflictOldRelPath, conflictNewRelPath, conflictWorkingRelPath, prejRelPath, treeConflictData);
            downgradeConflictStatement.done();
        }
        finally {
            downgradeConflictStatement.reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void collectConflicts18(SVNSqlJetDb sDb, List<Long> wcIds, List<File> paths) throws SVNException {
        SelectConflictsStatement selectConflictsStatement = new SelectConflictsStatement(sDb);
        try {
            while (selectConflictsStatement.next()) {
                long wcId = selectConflictsStatement.getColumnLong(SVNWCDbSchema.ACTUAL_NODE__Fields.wc_id);
                File localRelPath = SvnWcDbStatementUtil.getColumnPath(selectConflictsStatement, SVNWCDbSchema.ACTUAL_NODE__Fields.local_relpath);
                wcIds.add(wcId);
                paths.add(localRelPath);
            }
        }
        finally {
            selectConflictsStatement.reset();
        }
    }

    private static class DowngradeConflictStatement
    extends SVNSqlJetUpdateStatement {
        public DowngradeConflictStatement(SVNSqlJetDb sDb) throws SVNException {
            super(sDb, SVNWCDbSchema.ACTUAL_NODE);
        }

        @Override
        public Map<String, Object> getUpdateValues() throws SVNException {
            HashMap<String, Object> values2 = new HashMap<String, Object>();
            values2.put(SVNWCDbSchema.ACTUAL_NODE__Fields.conflict_old.name(), this.getBind(3));
            values2.put(SVNWCDbSchema.ACTUAL_NODE__Fields.conflict_new.name(), this.getBind(4));
            values2.put(SVNWCDbSchema.ACTUAL_NODE__Fields.conflict_working.name(), this.getBind(5));
            values2.put(SVNWCDbSchema.ACTUAL_NODE__Fields.prop_reject.name(), this.getBind(6));
            values2.put(SVNWCDbSchema.ACTUAL_NODE__Fields.tree_conflict_data.name(), this.getBind(7));
            values2.put(SVNWCDbSchema.ACTUAL_NODE__Fields.conflict_data.name(), null);
            return values2;
        }

        @Override
        protected Object[] getWhere() throws SVNException {
            return new Object[]{this.getBind(1), this.getBind(2)};
        }
    }

    private static class SelectConflictsStatement
    extends SVNSqlJetSelectFieldsStatement<SVNWCDbSchema.ACTUAL_NODE__Fields> {
        public SelectConflictsStatement(SVNSqlJetDb sDb) throws SVNException {
            super(sDb, SVNWCDbSchema.ACTUAL_NODE);
        }

        @Override
        protected void defineFields() {
            this.fields.add(SVNWCDbSchema.ACTUAL_NODE__Fields.wc_id);
            this.fields.add(SVNWCDbSchema.ACTUAL_NODE__Fields.local_relpath);
            this.fields.add(SVNWCDbSchema.ACTUAL_NODE__Fields.conflict_data);
        }

        @Override
        protected boolean isFilterPassed() throws SVNException {
            return !this.isColumnNull(SVNWCDbSchema.ACTUAL_NODE__Fields.conflict_data);
        }

        @Override
        protected Object[] getWhere() throws SVNException {
            return null;
        }
    }
}

