/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.db;

import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.tmatesoft.sqljet.core.SqlJetException;
import org.tmatesoft.sqljet.core.SqlJetValueType;
import org.tmatesoft.sqljet.core.internal.ISqlJetMemoryPointer;
import org.tmatesoft.sqljet.core.internal.SqlJetUtility;
import org.tmatesoft.sqljet.core.schema.ISqlJetColumnDef;
import org.tmatesoft.sqljet.core.table.ISqlJetCursor;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.internal.db.SVNSqlJetDb;
import org.tmatesoft.svn.core.internal.db.SVNSqlJetTableStatement;
import org.tmatesoft.svn.core.internal.wc17.db.statement.SVNWCDbSchema;

public class SVNSqlJetSelectStatement
extends SVNSqlJetTableStatement {
    private String indexName;
    private Map<String, Object> rowValues;

    public SVNSqlJetSelectStatement(SVNSqlJetDb sDb, Enum<?> fromTable) throws SVNException {
        this(sDb, fromTable.toString());
    }

    public SVNSqlJetSelectStatement(SVNSqlJetDb sDb, Enum<?> fromTable, Enum<?> indexName) throws SVNException {
        this(sDb, fromTable.toString(), indexName != null ? indexName.toString() : null);
    }

    public SVNSqlJetSelectStatement(SVNSqlJetDb sDb, String fromTable) throws SVNException {
        super(sDb, fromTable);
    }

    public SVNSqlJetSelectStatement(SVNSqlJetDb sDb, String fromTable, String indexName) throws SVNException {
        this(sDb, fromTable);
        this.indexName = indexName;
    }

    @Override
    protected ISqlJetCursor openCursor() throws SVNException {
        try {
            Object[] where = this.getWhere();
            if (this.isPathScoped() && this.isPathScopeInIndex()) {
                where = new Object[]{where[0], this.getPathScope()};
                return this.getTable().scope(this.getIndexName(), where, null);
            }
            return this.getTable().lookup(this.getIndexName(), where);
        }
        catch (SqlJetException e) {
            SVNSqlJetDb.createSqlJetError(e);
            return null;
        }
    }

    private boolean isPathScoped() throws SVNException {
        Object[] where = this.getWhere();
        if (this.getPathScope() != null && this.getIndexName() == null && SVNWCDbSchema.NODES.toString().equals(this.getTableName()) && where.length == 1) {
            return true;
        }
        if (this.getPathScope() != null && this.getIndexName() == SVNWCDbSchema.NODES__Indices.I_NODES_PARENT.name() && SVNWCDbSchema.NODES.toString().equals(this.getTableName()) && where.length == 1) {
            return true;
        }
        return this.getPathScope() != null && this.getIndexName() == SVNWCDbSchema.NODES__Indices.I_NODES_MOVED.name() && SVNWCDbSchema.NODES.toString().equals(this.getTableName()) && where.length == 1;
    }

    protected String getPathScope() {
        return null;
    }

    protected boolean isStrictiDescendant() {
        return false;
    }

    protected boolean isPathScopeInIndex() throws SVNException {
        Enum<?> rowPathField = this.getRowPathField();
        return rowPathField == this.getDefaultRowPathField();
    }

    protected String getIndexName() {
        return this.indexName;
    }

    public void setIndexName(String indexName) {
        this.indexName = indexName;
    }

    protected Object[] getWhere() throws SVNException {
        if (this.binds.size() == 0) {
            return null;
        }
        return this.binds.toArray();
    }

    @Override
    public boolean next() throws SVNException {
        boolean next = false;
        do {
            next = super.next();
            this.loadRowValues(next);
            if (next && this.pathScopeMatches()) continue;
        } while (next && !this.pathIsDecendant());
        while (next && !this.isFilterPassed()) {
            do {
                next = super.next();
                this.loadRowValues(next);
                if (!next || this.pathScopeMatches()) continue;
                return false;
            } while (next && !this.pathIsDecendant());
        }
        return next;
    }

    private boolean pathScopeMatches() throws SVNException {
        if (this.isPathScoped()) {
            String rowPath = this.getRowPath();
            if (!(!"".equals(this.getPathScope()) || this.isStrictiDescendant() && "".equals(rowPath))) {
                return true;
            }
            if (rowPath != null) {
                return !this.isStrictiDescendant() && this.getPathScope().equals(rowPath) || rowPath.startsWith(this.getPathScope());
            }
            return false;
        }
        return true;
    }

    private boolean pathIsDecendant() throws SVNException {
        if (this.getPathScope() != null) {
            String rowPath = this.getRowPath();
            if (rowPath != null) {
                if (!(!"".equals(this.getPathScope()) || this.isStrictiDescendant() && "".equals(rowPath))) {
                    return true;
                }
                return !this.isStrictiDescendant() && this.getPathScope().equals(rowPath) || rowPath.startsWith(this.getPathScope() + "/");
            }
            return false;
        }
        return true;
    }

    protected Enum<?> getRowPathField() throws SVNException {
        return this.getDefaultRowPathField();
    }

    private Enum<?> getDefaultRowPathField() {
        if (SVNWCDbSchema.NODES__Indices.I_NODES_PARENT.toString().equals(this.getIndexName())) {
            return SVNWCDbSchema.NODES__Fields.parent_relpath;
        }
        if (SVNWCDbSchema.NODES__Indices.I_NODES_MOVED.toString().equals(this.getIndexName())) {
            return SVNWCDbSchema.NODES__Fields.moved_to;
        }
        return SVNWCDbSchema.NODES__Fields.local_relpath;
    }

    protected String getRowPath() throws SVNException {
        Enum<?> rowPathField = this.getRowPathField();
        if (rowPathField == null) {
            return null;
        }
        return (String)this.rowValues.get(rowPathField.name());
    }

    protected boolean isFilterPassed() throws SVNException {
        return true;
    }

    @Override
    public boolean eof() throws SVNException {
        boolean eof = true;
        do {
            eof = eof ? super.eof() : !super.next();
            this.loadRowValues(!eof);
            if (eof || this.pathScopeMatches()) continue;
            return true;
        } while (!eof && !this.pathIsDecendant());
        while (!eof && !this.isFilterPassed()) {
            do {
                eof = !super.next();
                this.loadRowValues(!eof);
                if (eof || this.pathScopeMatches()) continue;
                return true;
            } while (!eof && !this.pathIsDecendant());
        }
        return eof;
    }

    private void loadRowValues(boolean has) throws SVNException {
        if (has) {
            this.rowValues = this.getRowValues2(this.rowValues);
        } else if (this.rowValues != null) {
            this.rowValues.clear();
        }
    }

    public Map<String, Object> getRowValues2(Map<String, Object> v) throws SVNException {
        v = v == null ? new HashMap<String, Object>() : v;
        try {
            Object[] values2;
            List<ISqlJetColumnDef> columns = this.getTable().getDefinition().getColumns();
            Object[] rValues = this.getCursor().getRowValues();
            if (rValues.length < columns.size()) {
                values2 = new Object[columns.size()];
                System.arraycopy(rValues, 0, values2, 0, rValues.length);
            } else {
                values2 = rValues;
            }
            for (int i = 0; i < values2.length; ++i) {
                v.put(columns.get(i).getName(), values2[i]);
            }
            return v;
        }
        catch (SqlJetException e) {
            SVNSqlJetDb.createSqlJetError(e);
            return null;
        }
    }

    @Override
    public Map<String, Object> getRowValues() throws SVNException {
        HashMap<String, Object> v = new HashMap<String, Object>();
        try {
            List<ISqlJetColumnDef> columns = this.getTable().getDefinition().getColumns();
            for (ISqlJetColumnDef column : columns) {
                String colName = column.getName();
                SqlJetValueType fieldType = this.getCursor().getFieldType(colName);
                if (fieldType == SqlJetValueType.NULL) {
                    v.put(colName, null);
                    continue;
                }
                if (fieldType == SqlJetValueType.BLOB) {
                    v.put(colName, this.getCursor().getBlobAsArray(colName));
                    continue;
                }
                v.put(colName, this.getCursor().getValue(colName));
            }
            return v;
        }
        catch (SqlJetException e) {
            SVNSqlJetDb.createSqlJetError(e);
            return null;
        }
    }

    @Override
    protected Object getColumn(String f) throws SVNException {
        return this.rowValues != null ? this.rowValues.get(f) : null;
    }

    @Override
    protected long getColumnLong(String f) throws SVNException {
        if (this.rowValues == null) {
            return 0L;
        }
        Object v = this.rowValues.get(f);
        if (v instanceof Long) {
            return (Long)v;
        }
        if (v instanceof String) {
            try {
                return Long.parseLong((String)v);
            }
            catch (NumberFormatException nfe) {
                return 0L;
            }
        }
        return 0L;
    }

    @Override
    protected String getColumnString(String f) throws SVNException {
        if (this.rowValues == null) {
            return null;
        }
        Object v = this.rowValues.get(f);
        if (v == null) {
            return null;
        }
        return v instanceof String ? (String)v : v.toString();
    }

    @Override
    protected boolean isColumnNull(String f) throws SVNException {
        if (this.rowValues == null) {
            return true;
        }
        return this.rowValues.get(f) == null;
    }

    @Override
    protected byte[] getColumnBlob(String f) throws SVNException {
        if (this.rowValues == null) {
            return null;
        }
        Object v = this.rowValues.get(f);
        if (v instanceof ISqlJetMemoryPointer) {
            ISqlJetMemoryPointer buffer = (ISqlJetMemoryPointer)v;
            return buffer != null ? SqlJetUtility.readByteBuffer(buffer) : null;
        }
        if (v instanceof String) {
            try {
                return ((String)v).getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                return ((String)v).getBytes();
            }
        }
        if (v instanceof byte[]) {
            return (byte[])v;
        }
        return null;
    }

    @Override
    public void reset() throws SVNException {
        if (this.rowValues != null) {
            this.rowValues.clear();
        }
        super.reset();
    }

    protected static boolean isStrictDescendantOf(String descendant, String ancestor) {
        return descendant.startsWith(ancestor + "/");
    }
}

