/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.sqljet.core.internal.schema;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.antlr.runtime.ANTLRStringStream;
import org.antlr.runtime.CharStream;
import org.antlr.runtime.CommonToken;
import org.antlr.runtime.CommonTokenStream;
import org.antlr.runtime.ParserRuleReturnScope;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.RuleReturnScope;
import org.antlr.runtime.tree.CommonTree;
import org.tmatesoft.sqljet.core.SqlJetErrorCode;
import org.tmatesoft.sqljet.core.SqlJetException;
import org.tmatesoft.sqljet.core.internal.ISqlJetBtree;
import org.tmatesoft.sqljet.core.internal.ISqlJetDbHandle;
import org.tmatesoft.sqljet.core.internal.SqlJetBtreeTableCreateFlags;
import org.tmatesoft.sqljet.core.internal.SqlJetUtility;
import org.tmatesoft.sqljet.core.internal.lang.SqlLexer;
import org.tmatesoft.sqljet.core.internal.lang.SqlParser;
import org.tmatesoft.sqljet.core.internal.schema.SqlJetAlterTableDef;
import org.tmatesoft.sqljet.core.internal.schema.SqlJetBaseIndexDef;
import org.tmatesoft.sqljet.core.internal.schema.SqlJetIndexDef;
import org.tmatesoft.sqljet.core.internal.schema.SqlJetTableDef;
import org.tmatesoft.sqljet.core.internal.schema.SqlJetTriggerDef;
import org.tmatesoft.sqljet.core.internal.schema.SqlJetViewDef;
import org.tmatesoft.sqljet.core.internal.schema.SqlJetVirtualTableDef;
import org.tmatesoft.sqljet.core.internal.table.ISqlJetBtreeDataTable;
import org.tmatesoft.sqljet.core.internal.table.ISqlJetBtreeSchemaTable;
import org.tmatesoft.sqljet.core.internal.table.SqlJetBtreeDataTable;
import org.tmatesoft.sqljet.core.internal.table.SqlJetBtreeIndexTable;
import org.tmatesoft.sqljet.core.internal.table.SqlJetBtreeSchemaTable;
import org.tmatesoft.sqljet.core.schema.ISqlJetColumnConstraint;
import org.tmatesoft.sqljet.core.schema.ISqlJetColumnDef;
import org.tmatesoft.sqljet.core.schema.ISqlJetColumnDefault;
import org.tmatesoft.sqljet.core.schema.ISqlJetColumnNotNull;
import org.tmatesoft.sqljet.core.schema.ISqlJetColumnPrimaryKey;
import org.tmatesoft.sqljet.core.schema.ISqlJetColumnUnique;
import org.tmatesoft.sqljet.core.schema.ISqlJetIndexDef;
import org.tmatesoft.sqljet.core.schema.ISqlJetIndexedColumn;
import org.tmatesoft.sqljet.core.schema.ISqlJetSchema;
import org.tmatesoft.sqljet.core.schema.ISqlJetTableConstraint;
import org.tmatesoft.sqljet.core.schema.ISqlJetTableDef;
import org.tmatesoft.sqljet.core.schema.ISqlJetTablePrimaryKey;
import org.tmatesoft.sqljet.core.schema.ISqlJetTableUnique;
import org.tmatesoft.sqljet.core.schema.ISqlJetTriggerDef;
import org.tmatesoft.sqljet.core.schema.ISqlJetViewDef;
import org.tmatesoft.sqljet.core.schema.ISqlJetVirtualTableDef;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SqlJetSchema
implements ISqlJetSchema {
    private static final String NAME_RESERVED = "Name '%s' is reserved to internal use";
    private static String AUTOINDEX_PREFIX = "sqlite_autoindex_";
    private static final String CANT_DELETE_IMPLICIT_INDEX = "Can't delete implicit index \"%s\"";
    private static final String CREATE_TABLE_SQLITE_SEQUENCE = "CREATE TABLE sqlite_sequence(name,seq)";
    private static final String SQLITE_SEQUENCE = "SQLITE_SEQUENCE";
    public static final Set<SqlJetBtreeTableCreateFlags> BTREE_CREATE_TABLE_FLAGS = SqlJetUtility.of(SqlJetBtreeTableCreateFlags.INTKEY, SqlJetBtreeTableCreateFlags.LEAFDATA);
    public static final Set<SqlJetBtreeTableCreateFlags> BTREE_CREATE_INDEX_FLAGS = SqlJetUtility.of(SqlJetBtreeTableCreateFlags.ZERODATA);
    private static final String TABLE_TYPE = "table";
    private static final String INDEX_TYPE = "index";
    private static final String VIEW_TYPE = "view";
    private static final String TRIGGER_TYPE = "trigger";
    private final ISqlJetDbHandle db;
    private final ISqlJetBtree btree;
    private final Map<String, ISqlJetTableDef> tableDefs = new TreeMap<String, ISqlJetTableDef>(String.CASE_INSENSITIVE_ORDER);
    private final Map<String, ISqlJetIndexDef> indexDefs = new TreeMap<String, ISqlJetIndexDef>(String.CASE_INSENSITIVE_ORDER);
    private Map<String, ISqlJetVirtualTableDef> virtualTableDefs = new TreeMap<String, ISqlJetVirtualTableDef>(String.CASE_INSENSITIVE_ORDER);
    private Map<String, ISqlJetViewDef> viewDefs = new TreeMap<String, ISqlJetViewDef>(String.CASE_INSENSITIVE_ORDER);
    private Map<String, ISqlJetTriggerDef> triggerDefs = new TreeMap<String, ISqlJetTriggerDef>(String.CASE_INSENSITIVE_ORDER);

    public SqlJetSchema(ISqlJetDbHandle db, ISqlJetBtree btree) throws SqlJetException {
        this.db = db;
        this.btree = btree;
        this.init();
    }

    ISqlJetBtreeSchemaTable openSchemaTable(boolean write) throws SqlJetException {
        return new SqlJetBtreeSchemaTable(this.btree, write);
    }

    private void init() throws SqlJetException {
        if (this.db.getOptions().getSchemaVersion() == 0) {
            return;
        }
        ISqlJetBtreeSchemaTable table = this.openSchemaTable(false);
        try {
            table.lock();
            try {
                this.readShema(table);
            }
            finally {
                table.unlock();
            }
        }
        finally {
            table.close();
        }
    }

    public ISqlJetDbHandle getDb() {
        return this.db;
    }

    public ISqlJetBtree getBtree() {
        return this.btree;
    }

    @Override
    public Set<String> getTableNames() throws SqlJetException {
        this.db.getMutex().enter();
        try {
            TreeSet<String> s = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
            s.addAll(this.tableDefs.keySet());
            TreeSet<String> treeSet = s;
            return treeSet;
        }
        finally {
            this.db.getMutex().leave();
        }
    }

    @Override
    public ISqlJetTableDef getTable(String name) throws SqlJetException {
        this.db.getMutex().enter();
        try {
            ISqlJetTableDef iSqlJetTableDef = this.tableDefs.get(name);
            return iSqlJetTableDef;
        }
        finally {
            this.db.getMutex().leave();
        }
    }

    @Override
    public Set<String> getIndexNames() throws SqlJetException {
        this.db.getMutex().enter();
        try {
            TreeSet<String> s = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
            s.addAll(this.indexDefs.keySet());
            TreeSet<String> treeSet = s;
            return treeSet;
        }
        finally {
            this.db.getMutex().leave();
        }
    }

    @Override
    public ISqlJetIndexDef getIndex(String name) throws SqlJetException {
        this.db.getMutex().enter();
        try {
            ISqlJetIndexDef iSqlJetIndexDef = this.indexDefs.get(name);
            return iSqlJetIndexDef;
        }
        finally {
            this.db.getMutex().leave();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<ISqlJetIndexDef> getIndexes(String tableName) throws SqlJetException {
        this.db.getMutex().enter();
        try {
            HashSet<ISqlJetIndexDef> result = new HashSet<ISqlJetIndexDef>();
            for (ISqlJetIndexDef index : this.indexDefs.values()) {
                if (!index.getTableName().equals(tableName)) continue;
                result.add(index);
            }
            Set set = Collections.unmodifiableSet(result);
            return set;
        }
        finally {
            this.db.getMutex().leave();
        }
    }

    @Override
    public Set<String> getVirtualTableNames() throws SqlJetException {
        this.db.getMutex().enter();
        try {
            TreeSet<String> s = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
            s.addAll(this.virtualTableDefs.keySet());
            TreeSet<String> treeSet = s;
            return treeSet;
        }
        finally {
            this.db.getMutex().leave();
        }
    }

    @Override
    public ISqlJetVirtualTableDef getVirtualTable(String name) throws SqlJetException {
        this.db.getMutex().enter();
        try {
            ISqlJetVirtualTableDef iSqlJetVirtualTableDef = this.virtualTableDefs.get(name);
            return iSqlJetVirtualTableDef;
        }
        finally {
            this.db.getMutex().leave();
        }
    }

    @Override
    public ISqlJetViewDef getView(String name) throws SqlJetException {
        this.db.getMutex().enter();
        try {
            ISqlJetViewDef iSqlJetViewDef = this.viewDefs.get(name);
            return iSqlJetViewDef;
        }
        finally {
            this.db.getMutex().leave();
        }
    }

    @Override
    public Set<String> getViewNames() throws SqlJetException {
        this.db.getMutex().enter();
        try {
            TreeSet<String> s = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
            s.addAll(this.viewDefs.keySet());
            TreeSet<String> treeSet = s;
            return treeSet;
        }
        finally {
            this.db.getMutex().leave();
        }
    }

    @Override
    public ISqlJetTriggerDef getTrigger(String name) throws SqlJetException {
        this.db.getMutex().enter();
        try {
            ISqlJetTriggerDef iSqlJetTriggerDef = this.triggerDefs.get(name);
            return iSqlJetTriggerDef;
        }
        finally {
            this.db.getMutex().leave();
        }
    }

    @Override
    public Set<String> getTriggerNames() throws SqlJetException {
        this.db.getMutex().enter();
        try {
            TreeSet<String> s = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
            s.addAll(this.triggerDefs.keySet());
            TreeSet<String> treeSet = s;
            return treeSet;
        }
        finally {
            this.db.getMutex().leave();
        }
    }

    private void readShema(ISqlJetBtreeSchemaTable table) throws SqlJetException {
        table.first();
        while (!table.eof()) {
            String name;
            String type = table.getTypeField();
            if (null != type && null != (name = table.getNameField())) {
                CommonTree ast;
                String sql;
                int page = table.getPageField();
                if (TABLE_TYPE.equals(type)) {
                    String sql2 = table.getSqlField();
                    CommonTree ast2 = (CommonTree)this.parseTable(sql2).getTree();
                    if (!this.isCreateVirtualTable(ast2)) {
                        SqlJetTableDef tableDef = new SqlJetTableDef(ast2, page);
                        if (!name.equals(tableDef.getName())) {
                            throw new SqlJetException(SqlJetErrorCode.CORRUPT);
                        }
                        tableDef.setRowId(table.getRowId());
                        this.tableDefs.put(name, tableDef);
                    } else {
                        SqlJetVirtualTableDef virtualTableDef = new SqlJetVirtualTableDef(ast2, page);
                        if (!name.equals(virtualTableDef.getTableName())) {
                            throw new SqlJetException(SqlJetErrorCode.CORRUPT);
                        }
                        virtualTableDef.setRowId(table.getRowId());
                        this.virtualTableDefs.put(name, virtualTableDef);
                    }
                } else if (INDEX_TYPE.equals(type)) {
                    String tableName = table.getTableField();
                    sql = table.getSqlField();
                    if (null != sql) {
                        ast = (CommonTree)this.parseIndex(sql).getTree();
                        SqlJetIndexDef indexDef = new SqlJetIndexDef(ast, page);
                        if (!name.equals(indexDef.getName())) {
                            throw new SqlJetException(SqlJetErrorCode.CORRUPT);
                        }
                        if (!tableName.equals(indexDef.getTableName())) {
                            throw new SqlJetException(SqlJetErrorCode.CORRUPT);
                        }
                        indexDef.setRowId(table.getRowId());
                        this.indexDefs.put(name, indexDef);
                    } else {
                        SqlJetBaseIndexDef indexDef = new SqlJetBaseIndexDef(name, tableName, page);
                        indexDef.setRowId(table.getRowId());
                        this.indexDefs.put(name, indexDef);
                    }
                } else if (VIEW_TYPE.equals(type)) {
                    String viewName = table.getTableField();
                    sql = table.getSqlField();
                    ast = (CommonTree)this.parseView(sql).getTree();
                    SqlJetViewDef viewDef = new SqlJetViewDef(sql, ast);
                    viewDef.setRowId(table.getRowId());
                    this.viewDefs.put(viewName, viewDef);
                } else if (TRIGGER_TYPE.equals(type)) {
                    String triggerName = table.getNameField();
                    sql = table.getSqlField();
                    ast = (CommonTree)this.parseTrigger(sql).getTree();
                    SqlJetTriggerDef triggerDef = new SqlJetTriggerDef(sql, ast);
                    triggerDef.setRowId(table.getRowId());
                    this.triggerDefs.put(triggerName, triggerDef);
                }
            }
            table.next();
        }
        this.bindIndexes();
    }

    private void bindIndexes() {
        for (ISqlJetIndexDef indexDef : this.indexDefs.values()) {
            SqlJetIndexDef i;
            String tableName;
            ISqlJetTableDef tableDef;
            if (!(indexDef instanceof SqlJetIndexDef) || (tableDef = this.tableDefs.get(tableName = (i = (SqlJetIndexDef)indexDef).getTableName())) == null) continue;
            i.bindColumns(tableDef);
        }
    }

    private boolean isCreateVirtualTable(CommonTree ast) {
        CommonTree optionsNode = (CommonTree)ast.getChild(0);
        for (int i = 0; i < optionsNode.getChildCount(); ++i) {
            CommonTree optionNode = (CommonTree)optionsNode.getChild(i);
            if (!"virtual".equalsIgnoreCase(optionNode.getText())) continue;
            return true;
        }
        return false;
    }

    private RuleReturnScope parseTable(String sql) throws SqlJetException {
        try {
            ANTLRStringStream chars = new ANTLRStringStream(sql);
            SqlLexer lexer = new SqlLexer(chars);
            CommonTokenStream tokens = new CommonTokenStream(lexer);
            SqlParser parser = new SqlParser(tokens);
            return parser.schema_create_table_stmt();
        }
        catch (RecognitionException re) {
            throw new SqlJetException(SqlJetErrorCode.ERROR, "Invalid sql statement: " + sql);
        }
    }

    private RuleReturnScope parseView(String sql) throws SqlJetException {
        try {
            ANTLRStringStream chars = new ANTLRStringStream(sql);
            SqlLexer lexer = new SqlLexer(chars);
            CommonTokenStream tokens = new CommonTokenStream(lexer);
            SqlParser parser = new SqlParser(tokens);
            return parser.create_view_stmt();
        }
        catch (RecognitionException re) {
            throw new SqlJetException(SqlJetErrorCode.ERROR, "Invalid sql statement: " + sql);
        }
    }

    private RuleReturnScope parseTrigger(String sql) throws SqlJetException {
        try {
            ANTLRStringStream chars = new ANTLRStringStream(sql);
            SqlLexer lexer = new SqlLexer(chars);
            CommonTokenStream tokens = new CommonTokenStream(lexer);
            SqlParser parser = new SqlParser(tokens);
            return parser.create_trigger_stmt();
        }
        catch (RecognitionException re) {
            throw new SqlJetException(SqlJetErrorCode.ERROR, "Invalid sql statement: " + sql);
        }
    }

    private ParserRuleReturnScope parseIndex(String sql) throws SqlJetException {
        try {
            ANTLRStringStream chars = new ANTLRStringStream(sql);
            SqlLexer lexer = new SqlLexer(chars);
            CommonTokenStream tokens = new CommonTokenStream(lexer);
            SqlParser parser = new SqlParser(tokens);
            return parser.create_index_stmt();
        }
        catch (RecognitionException re) {
            throw new SqlJetException(SqlJetErrorCode.ERROR, "Invalid sql statement: " + sql);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        this.db.getMutex().enter();
        try {
            StringBuffer buffer = new StringBuffer();
            buffer.append("Tables:\n");
            for (ISqlJetTableDef tableDef : this.tableDefs.values()) {
                buffer.append(tableDef.toString());
                buffer.append('\n');
            }
            buffer.append("Indexes:\n");
            for (ISqlJetIndexDef indexDef : this.indexDefs.values()) {
                buffer.append(indexDef.toString());
                buffer.append('\n');
            }
            String string = buffer.toString();
            return string;
        }
        finally {
            this.db.getMutex().leave();
        }
    }

    public ISqlJetTableDef createTable(String sql) throws SqlJetException {
        this.db.getMutex().enter();
        try {
            ISqlJetTableDef iSqlJetTableDef = this.createTableSafe(sql, false);
            return iSqlJetTableDef;
        }
        finally {
            this.db.getMutex().leave();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ISqlJetTableDef createTableSafe(String sql, boolean internal) throws SqlJetException {
        RuleReturnScope parseTable = this.parseTable(sql);
        CommonTree ast = (CommonTree)parseTable.getTree();
        if (this.isCreateVirtualTable(ast)) {
            throw new SqlJetException(SqlJetErrorCode.ERROR);
        }
        SqlJetTableDef tableDef = new SqlJetTableDef(ast, 0);
        if (null == tableDef.getName()) {
            throw new SqlJetException(SqlJetErrorCode.ERROR);
        }
        String tableName = tableDef.getName();
        if ("".equals(tableName)) {
            throw new SqlJetException(SqlJetErrorCode.ERROR);
        }
        if (!internal) {
            this.checkNameReserved(tableName);
        }
        if (this.tableDefs.containsKey(tableName)) {
            if (tableDef.isKeepExisting()) {
                return this.tableDefs.get(tableName);
            }
            throw new SqlJetException(SqlJetErrorCode.ERROR, "Table \"" + tableName + "\" exists already");
        }
        this.checkNameConflict(SqlJetSchemaObjectType.TABLE, tableName);
        this.checkFieldNamesRepeatsConflict(tableDef.getName(), tableDef.getColumns());
        List<ISqlJetColumnDef> columns = tableDef.getColumns();
        if (null == columns || 0 == columns.size()) {
            throw new SqlJetException(SqlJetErrorCode.ERROR);
        }
        String createTableSql = this.getCreateTableSql(parseTable);
        ISqlJetBtreeSchemaTable schemaTable = this.openSchemaTable(true);
        try {
            SqlJetTableDef sqlJetTableDef;
            schemaTable.lock();
            try {
                this.db.getOptions().changeSchemaVersion();
                int page = this.btree.createTable(BTREE_CREATE_TABLE_FLAGS);
                long rowId = schemaTable.newRowId();
                schemaTable.insert(null, rowId, null, 0, 0, false);
                this.addConstraints(schemaTable, tableDef);
                schemaTable.updateRecord(rowId, TABLE_TYPE, tableName, tableName, page, createTableSql);
                tableDef.setPage(page);
                tableDef.setRowId(rowId);
                this.tableDefs.put(tableName, tableDef);
                sqlJetTableDef = tableDef;
            }
            catch (Throwable throwable) {
                schemaTable.unlock();
                throw throwable;
            }
            schemaTable.unlock();
            return sqlJetTableDef;
        }
        finally {
            schemaTable.close();
        }
    }

    private void checkFieldNamesRepeatsConflict(String tableName, List<ISqlJetColumnDef> columns) throws SqlJetException {
        HashSet<String> names = new HashSet<String>();
        for (ISqlJetColumnDef columnDef : columns) {
            String name = columnDef.getName();
            if (names.contains(name)) {
                throw new SqlJetException(SqlJetErrorCode.ERROR, String.format("Definition for table '%s' has conflict of repeating fields named '%s'", tableName, name));
            }
            names.add(name);
        }
    }

    private String getCreateTableSql(RuleReturnScope parseTable) {
        return String.format("CREATE TABLE %s", this.getCoreSQL(parseTable));
    }

    private String getCreateIndexSql(RuleReturnScope parseIndex) {
        return String.format("CREATE INDEX %s", this.getCoreSQL(parseIndex));
    }

    private String getCreateIndexUniqueSql(RuleReturnScope parseIndex) {
        return String.format("CREATE UNIQUE INDEX %s", this.getCoreSQL(parseIndex));
    }

    private String getCreateVirtualTableSql(RuleReturnScope parseTable) {
        return String.format("CREATE VIRTUAL TABLE %s", this.getCoreSQL(parseTable));
    }

    private String getCoreSQL(RuleReturnScope parsedSQL) {
        CommonTree ast = (CommonTree)parsedSQL.getTree();
        CommonToken nameToken = (CommonToken)((CommonTree)ast.getChild(1)).getToken();
        CharStream inputStream2 = nameToken.getInputStream();
        CommonToken stopToken = (CommonToken)parsedSQL.getStop();
        return inputStream2.substring(nameToken.getStartIndex(), stopToken.getStopIndex());
    }

    static String generateAutoIndexName(String tableName, int i) {
        return AUTOINDEX_PREFIX + tableName + "_" + Integer.toString(i);
    }

    private void addConstraints(ISqlJetBtreeSchemaTable schemaTable, SqlJetTableDef tableDef) throws SqlJetException {
        String tableName = tableDef.getName();
        List<ISqlJetColumnDef> columns = tableDef.getColumns();
        int i = 0;
        for (ISqlJetColumnDef column : columns) {
            List<ISqlJetColumnConstraint> constraints = column.getConstraints();
            if (null == constraints) continue;
            for (ISqlJetColumnConstraint constraint : constraints) {
                if (constraint instanceof ISqlJetColumnPrimaryKey) {
                    ISqlJetColumnPrimaryKey pk = (ISqlJetColumnPrimaryKey)constraint;
                    if (!column.hasExactlyIntegerType()) {
                        if (pk.isAutoincremented()) {
                            throw new SqlJetException(SqlJetErrorCode.ERROR, "AUTOINCREMENT is allowed only for INTEGER PRIMARY KEY fields");
                        }
                        this.createAutoIndex(schemaTable, tableName, SqlJetSchema.generateAutoIndexName(tableName, ++i));
                        continue;
                    }
                    if (!pk.isAutoincremented()) continue;
                    this.checkSequenceTable();
                    continue;
                }
                if (!(constraint instanceof ISqlJetColumnUnique)) continue;
                this.createAutoIndex(schemaTable, tableName, SqlJetSchema.generateAutoIndexName(tableName, ++i));
            }
        }
        List<ISqlJetTableConstraint> constraints = tableDef.getConstraints();
        if (null != constraints) {
            for (ISqlJetTableConstraint constraint : constraints) {
                if (constraint instanceof ISqlJetTablePrimaryKey) {
                    boolean b = false;
                    ISqlJetTablePrimaryKey pk = (ISqlJetTablePrimaryKey)constraint;
                    if (pk.getColumns().size() == 1) {
                        String n = pk.getColumns().get(0);
                        ISqlJetColumnDef c = tableDef.getColumn(n);
                        boolean bl = b = c != null && c.hasExactlyIntegerType();
                    }
                    if (b) continue;
                    this.createAutoIndex(schemaTable, tableName, SqlJetSchema.generateAutoIndexName(tableName, ++i));
                    continue;
                }
                if (!(constraint instanceof ISqlJetTableUnique)) continue;
                this.createAutoIndex(schemaTable, tableName, SqlJetSchema.generateAutoIndexName(tableName, ++i));
            }
        }
    }

    private void checkSequenceTable() throws SqlJetException {
        if (!this.tableDefs.containsKey(SQLITE_SEQUENCE)) {
            this.createTableSafe(CREATE_TABLE_SQLITE_SEQUENCE, true);
        }
    }

    public ISqlJetBtreeDataTable openSequenceTable() throws SqlJetException {
        if (this.tableDefs.containsKey(SQLITE_SEQUENCE)) {
            return new SqlJetBtreeDataTable(this.btree, SQLITE_SEQUENCE, true);
        }
        return null;
    }

    private ISqlJetIndexDef createAutoIndex(ISqlJetBtreeSchemaTable schemaTable, String tableName, String autoIndexName) throws SqlJetException {
        int page = this.btree.createTable(BTREE_CREATE_INDEX_FLAGS);
        SqlJetBaseIndexDef indexDef = new SqlJetBaseIndexDef(autoIndexName, tableName, page);
        indexDef.setRowId(schemaTable.insertRecord(INDEX_TYPE, autoIndexName, tableName, page, null));
        this.indexDefs.put(autoIndexName, indexDef);
        return indexDef;
    }

    public ISqlJetIndexDef createIndex(String sql) throws SqlJetException {
        this.db.getMutex().enter();
        try {
            ISqlJetIndexDef iSqlJetIndexDef = this.createIndexSafe(sql);
            return iSqlJetIndexDef;
        }
        finally {
            this.db.getMutex().leave();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ISqlJetIndexDef createIndexSafe(String sql) throws SqlJetException {
        ParserRuleReturnScope parseIndex = this.parseIndex(sql);
        CommonTree ast = (CommonTree)parseIndex.getTree();
        SqlJetIndexDef indexDef = new SqlJetIndexDef(ast, 0);
        if (null == indexDef.getName()) {
            throw new SqlJetException(SqlJetErrorCode.ERROR);
        }
        String indexName = indexDef.getName();
        if ("".equals(indexName)) {
            throw new SqlJetException(SqlJetErrorCode.ERROR);
        }
        this.checkNameReserved(indexName);
        if (this.indexDefs.containsKey(indexName)) {
            if (indexDef.isKeepExisting()) {
                return this.indexDefs.get(indexName);
            }
            throw new SqlJetException(SqlJetErrorCode.ERROR, "Index \"" + indexName + "\" exists already");
        }
        this.checkNameConflict(SqlJetSchemaObjectType.INDEX, indexName);
        if (null == indexDef.getTableName()) {
            throw new SqlJetException(SqlJetErrorCode.ERROR);
        }
        String tableName = indexDef.getTableName();
        if ("".equals(tableName)) {
            throw new SqlJetException(SqlJetErrorCode.ERROR);
        }
        List<ISqlJetIndexedColumn> columns = indexDef.getColumns();
        if (null == columns) {
            throw new SqlJetException(SqlJetErrorCode.ERROR);
        }
        ISqlJetTableDef tableDef = this.getTable(tableName);
        if (null == tableDef) {
            throw new SqlJetException(SqlJetErrorCode.ERROR);
        }
        for (ISqlJetIndexedColumn column : columns) {
            if (null == column.getName()) {
                throw new SqlJetException(SqlJetErrorCode.ERROR);
            }
            String columnName = column.getName();
            if ("".equals(columnName)) {
                throw new SqlJetException(SqlJetErrorCode.ERROR);
            }
            if (null != tableDef.getColumn(columnName)) continue;
            throw new SqlJetException(SqlJetErrorCode.ERROR, "Column \"" + columnName + "\" not found in table \"" + tableName + "\"");
        }
        ISqlJetBtreeSchemaTable schemaTable = this.openSchemaTable(true);
        String createIndexSQL = indexDef.isUnique() ? this.getCreateIndexUniqueSql(parseIndex) : this.getCreateIndexSql(parseIndex);
        try {
            SqlJetIndexDef sqlJetIndexDef;
            schemaTable.lock();
            try {
                this.db.getOptions().changeSchemaVersion();
                int page = this.btree.createTable(BTREE_CREATE_INDEX_FLAGS);
                long rowId = schemaTable.insertRecord(INDEX_TYPE, indexName, tableName, page, createIndexSQL);
                indexDef.setPage(page);
                indexDef.setRowId(rowId);
                indexDef.bindColumns(tableDef);
                this.indexDefs.put(indexName, indexDef);
                SqlJetBtreeIndexTable indexTable = new SqlJetBtreeIndexTable(this.btree, indexDef.getName(), true);
                try {
                    indexTable.reindex(this);
                }
                finally {
                    indexTable.close();
                }
                sqlJetIndexDef = indexDef;
            }
            catch (Throwable throwable) {
                schemaTable.unlock();
                throw throwable;
            }
            schemaTable.unlock();
            return sqlJetIndexDef;
        }
        finally {
            schemaTable.close();
        }
    }

    public void dropTable(String tableName) throws SqlJetException {
        this.db.getMutex().enter();
        try {
            this.dropTableSafe(tableName);
        }
        finally {
            this.db.getMutex().leave();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dropTableSafe(String tableName) throws SqlJetException {
        if (null == tableName || "".equals(tableName)) {
            throw new SqlJetException(SqlJetErrorCode.MISUSE, "Table name must be not empty");
        }
        if (!this.tableDefs.containsKey(tableName)) {
            throw new SqlJetException(SqlJetErrorCode.MISUSE, "Table not found: " + tableName);
        }
        SqlJetTableDef tableDef = (SqlJetTableDef)this.tableDefs.get(tableName);
        this.dropTableIndexes(tableDef);
        ISqlJetBtreeSchemaTable schemaTable = this.openSchemaTable(true);
        try {
            schemaTable.lock();
            try {
                this.db.getOptions().changeSchemaVersion();
                if (!schemaTable.goToRow(tableDef.getRowId()) || !TABLE_TYPE.equals(schemaTable.getTypeField())) {
                    throw new SqlJetException(SqlJetErrorCode.CORRUPT);
                }
                String n = schemaTable.getNameField();
                if (null == n || !tableName.equals(n)) {
                    throw new SqlJetException(SqlJetErrorCode.CORRUPT);
                }
                schemaTable.delete();
            }
            finally {
                schemaTable.unlock();
            }
        }
        finally {
            schemaTable.close();
        }
        int page = tableDef.getPage();
        int moved = this.btree.dropTable(page);
        if (moved != 0) {
            this.movePage(page, moved);
        }
        this.tableDefs.remove(tableName);
    }

    private void dropTableIndexes(SqlJetTableDef tableDef) throws SqlJetException {
        String tableName = tableDef.getName();
        Iterator<Map.Entry<String, ISqlJetIndexDef>> iterator2 = this.indexDefs.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry<String, ISqlJetIndexDef> indexDefEntry = iterator2.next();
            String indexName = indexDefEntry.getKey();
            ISqlJetIndexDef indexDef = indexDefEntry.getValue();
            if (!indexDef.getTableName().equals(tableName) || !this.doDropIndex(indexName, true, false)) continue;
            iterator2.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean doDropIndex(String indexName, boolean allowAutoIndex, boolean throwIfFial) throws SqlJetException {
        if (!this.indexDefs.containsKey(indexName)) {
            if (!throwIfFial) return false;
            throw new SqlJetException(SqlJetErrorCode.MISUSE);
        }
        SqlJetBaseIndexDef indexDef = (SqlJetBaseIndexDef)this.indexDefs.get(indexName);
        if (!allowAutoIndex && indexDef.isImplicit()) {
            if (!throwIfFial) return false;
            throw new SqlJetException(SqlJetErrorCode.MISUSE, String.format(CANT_DELETE_IMPLICIT_INDEX, indexName));
        }
        ISqlJetBtreeSchemaTable schemaTable = this.openSchemaTable(true);
        try {
            schemaTable.lock();
            try {
                if (!schemaTable.goToRow(indexDef.getRowId()) || !INDEX_TYPE.equals(schemaTable.getTypeField())) {
                    if (throwIfFial) {
                        throw new SqlJetException(SqlJetErrorCode.INTERNAL);
                    }
                    boolean bl = false;
                    return bl;
                }
                String n = schemaTable.getNameField();
                if (null == n || !indexName.equals(n)) {
                    if (throwIfFial) {
                        throw new SqlJetException(SqlJetErrorCode.INTERNAL);
                    }
                    boolean bl = false;
                    return bl;
                }
                if (!allowAutoIndex && schemaTable.isNull(4)) {
                    if (throwIfFial) {
                        throw new SqlJetException(SqlJetErrorCode.MISUSE, String.format(CANT_DELETE_IMPLICIT_INDEX, indexName));
                    }
                    boolean bl = false;
                    return bl;
                }
                schemaTable.delete();
            }
            finally {
                schemaTable.unlock();
            }
        }
        finally {
            schemaTable.close();
        }
        int page = indexDef.getPage();
        int moved = this.btree.dropTable(page);
        if (moved == 0) return true;
        this.movePage(page, moved);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void movePage(int page, int moved) throws SqlJetException {
        ISqlJetBtreeSchemaTable schemaTable = this.openSchemaTable(true);
        try {
            schemaTable.lock();
            try {
                schemaTable.first();
                while (true) {
                    if (!schemaTable.eof()) {
                        long pageField = schemaTable.getPageField();
                        if (pageField == (long)moved) {
                            String nameField = schemaTable.getNameField();
                            schemaTable.updateRecord(schemaTable.getRowId(), schemaTable.getTypeField(), nameField, schemaTable.getTableField(), page, schemaTable.getSqlField());
                            ISqlJetIndexDef index = this.getIndex(nameField);
                            if (index != null) {
                                if (index instanceof SqlJetBaseIndexDef) {
                                    ((SqlJetBaseIndexDef)index).setPage(page);
                                }
                            } else {
                                ISqlJetTableDef table = this.getTable(nameField);
                                if (table != null && table instanceof SqlJetTableDef) {
                                    ((SqlJetTableDef)table).setPage(page);
                                }
                            }
                            return;
                        }
                        schemaTable.next();
                        continue;
                    }
                    break;
                }
            }
            finally {
                schemaTable.unlock();
            }
        }
        finally {
            schemaTable.close();
        }
    }

    public void dropIndex(String indexName) throws SqlJetException {
        this.db.getMutex().enter();
        try {
            this.dropIndexSafe(indexName);
        }
        finally {
            this.db.getMutex().leave();
        }
    }

    private void dropIndexSafe(String indexName) throws SqlJetException {
        if (null == indexName || "".equals(indexName)) {
            throw new SqlJetException(SqlJetErrorCode.MISUSE, "Index name must be not empty");
        }
        if (!this.indexDefs.containsKey(indexName)) {
            throw new SqlJetException(SqlJetErrorCode.MISUSE, "Index not found: " + indexName);
        }
        if (this.doDropIndex(indexName, false, true)) {
            this.db.getOptions().changeSchemaVersion();
            this.indexDefs.remove(indexName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ISqlJetTableDef alterTableSafe(SqlJetAlterTableDef alterTableDef) throws SqlJetException {
        assert (null != alterTableDef);
        String tableName = alterTableDef.getTableName();
        String tableQuotedName = alterTableDef.getTableQuotedName();
        String newTableName = alterTableDef.getNewTableName();
        String newTableQuotedName = alterTableDef.getNewTableQuotedName();
        ISqlJetColumnDef newColumnDef = alterTableDef.getNewColumnDef();
        if (null == tableName) {
            throw new SqlJetException(SqlJetErrorCode.MISUSE, "Table name isn't defined");
        }
        if (null == newTableName && null == newColumnDef) {
            throw new SqlJetException(SqlJetErrorCode.MISUSE, "Not defined any altering");
        }
        boolean renameTable = false;
        if (null != newTableName) {
            renameTable = true;
        } else {
            newTableName = tableName;
            newTableQuotedName = tableQuotedName;
        }
        if (renameTable && this.tableDefs.containsKey(newTableName)) {
            throw new SqlJetException(SqlJetErrorCode.MISUSE, String.format("Table \"%s\" already exists", newTableName));
        }
        SqlJetTableDef tableDef = (SqlJetTableDef)this.tableDefs.get(tableName);
        if (null == tableDef) {
            throw new SqlJetException(SqlJetErrorCode.MISUSE, String.format("Table \"%s\" not found", tableName));
        }
        List<ISqlJetColumnDef> columns = tableDef.getColumns();
        if (null != newColumnDef) {
            String fieldName = newColumnDef.getName();
            if (tableDef.getColumn(fieldName) != null) {
                throw new SqlJetException(SqlJetErrorCode.MISUSE, String.format("Field \"%s\" already exists in table \"%s\"", fieldName, tableName));
            }
            List<ISqlJetColumnConstraint> constraints = newColumnDef.getConstraints();
            if (null != constraints && 0 != constraints.size()) {
                boolean notNull = false;
                boolean defaultValue = false;
                for (ISqlJetColumnConstraint constraint : constraints) {
                    if (constraint instanceof ISqlJetColumnNotNull) {
                        notNull = true;
                        continue;
                    }
                    if (constraint instanceof ISqlJetColumnDefault) {
                        defaultValue = true;
                        continue;
                    }
                    throw new SqlJetException(SqlJetErrorCode.MISUSE, String.format("Invalid constraint: %s", constraint.toString()));
                }
                if (notNull && !defaultValue) {
                    throw new SqlJetException(SqlJetErrorCode.MISUSE, "NOT NULL requires to have DEFAULT value");
                }
            }
            columns = new ArrayList<ISqlJetColumnDef>(columns);
            columns.add(newColumnDef);
        }
        int page = tableDef.getPage();
        long rowId = tableDef.getRowId();
        SqlJetTableDef alterDef = new SqlJetTableDef(newTableQuotedName, null, tableDef.isTemporary(), false, columns, tableDef.getConstraints(), page, rowId);
        ISqlJetBtreeSchemaTable schemaTable = this.openSchemaTable(true);
        try {
            SqlJetTableDef sqlJetTableDef;
            schemaTable.lock();
            try {
                if (!schemaTable.goToRow(rowId)) {
                    throw new SqlJetException(SqlJetErrorCode.CORRUPT);
                }
                String typeField = schemaTable.getTypeField();
                String nameField = schemaTable.getNameField();
                String tableField = schemaTable.getTableField();
                int pageField = schemaTable.getPageField();
                if (null == typeField || !TABLE_TYPE.equals(typeField)) {
                    throw new SqlJetException(SqlJetErrorCode.CORRUPT);
                }
                if (null == nameField || !tableName.equals(nameField)) {
                    throw new SqlJetException(SqlJetErrorCode.CORRUPT);
                }
                if (null == tableField || !tableName.equals(tableField)) {
                    throw new SqlJetException(SqlJetErrorCode.CORRUPT);
                }
                if (0 == pageField || pageField != page) {
                    throw new SqlJetException(SqlJetErrorCode.CORRUPT);
                }
                String alteredSql = alterDef.toSQL();
                this.db.getOptions().changeSchemaVersion();
                schemaTable.updateRecord(rowId, TABLE_TYPE, newTableName, newTableName, page, alteredSql);
                if (renameTable && !tableName.equals(newTableName)) {
                    this.renameTablesIndices(schemaTable, tableName, newTableName, newTableQuotedName);
                }
                this.tableDefs.remove(tableName);
                this.tableDefs.put(newTableName, alterDef);
                sqlJetTableDef = alterDef;
            }
            catch (Throwable throwable) {
                schemaTable.unlock();
                throw throwable;
            }
            schemaTable.unlock();
            return sqlJetTableDef;
        }
        finally {
            schemaTable.close();
        }
    }

    private void renameTablesIndices(ISqlJetBtreeSchemaTable schemaTable, String tableName, String newTableName, String alterTableName) throws SqlJetException {
        Set<ISqlJetIndexDef> indexes = this.getIndexes(tableName);
        if (null == indexes || 0 == indexes.size()) {
            return;
        }
        int i = 0;
        for (ISqlJetIndexDef index : indexes) {
            if (index instanceof SqlJetBaseIndexDef) {
                SqlJetBaseIndexDef indexDef = (SqlJetBaseIndexDef)index;
                String indexName = indexDef.getName();
                long rowId = indexDef.getRowId();
                int page = indexDef.getPage();
                if (!schemaTable.goToRow(rowId)) {
                    throw new SqlJetException(SqlJetErrorCode.CORRUPT);
                }
                String typeField = schemaTable.getTypeField();
                String nameField = schemaTable.getNameField();
                String tableField = schemaTable.getTableField();
                int pageField = schemaTable.getPageField();
                if (null == typeField || !INDEX_TYPE.equals(typeField)) {
                    throw new SqlJetException(SqlJetErrorCode.CORRUPT);
                }
                if (null == nameField || !indexName.equals(nameField)) {
                    throw new SqlJetException(SqlJetErrorCode.CORRUPT);
                }
                if (null == tableField || !tableName.equals(tableField)) {
                    throw new SqlJetException(SqlJetErrorCode.CORRUPT);
                }
                if (0 == pageField || pageField != page) {
                    throw new SqlJetException(SqlJetErrorCode.CORRUPT);
                }
                indexDef.setTableName(newTableName);
                String newIndexName = indexName;
                String alteredIndexSql = null;
                if (index.isImplicit()) {
                    newIndexName = SqlJetSchema.generateAutoIndexName(tableName, ++i);
                    indexDef.setName(newIndexName);
                    this.indexDefs.remove(indexName);
                    this.indexDefs.put(newIndexName, indexDef);
                } else {
                    alteredIndexSql = this.getAlteredIndexSql(schemaTable.getSqlField(), alterTableName);
                }
                schemaTable.updateRecord(rowId, INDEX_TYPE, newIndexName, newTableName, page, alteredIndexSql);
                continue;
            }
            throw new SqlJetException(SqlJetErrorCode.INTERNAL);
        }
    }

    private String getAlteredIndexSql(String sql, String alterTableName) throws SqlJetException {
        ParserRuleReturnScope parsedSQL = this.parseIndex(sql);
        CommonTree ast = (CommonTree)((RuleReturnScope)parsedSQL).getTree();
        CommonToken nameToken = (CommonToken)((CommonTree)ast.getChild(2)).getToken();
        CharStream inputStream2 = nameToken.getInputStream();
        CommonToken stopToken = (CommonToken)((RuleReturnScope)parsedSQL).getStop();
        StringBuilder b = new StringBuilder();
        b.append(inputStream2.substring(0, nameToken.getStartIndex() - 1));
        b.append(alterTableName);
        b.append(inputStream2.substring(nameToken.getStopIndex() + 1, stopToken.getStopIndex()));
        return b.toString();
    }

    private ParserRuleReturnScope parseSqlStatement(String sql) throws SqlJetException {
        try {
            ANTLRStringStream chars = new ANTLRStringStream(sql);
            SqlLexer lexer = new SqlLexer(chars);
            CommonTokenStream tokens = new CommonTokenStream(lexer);
            SqlParser parser = new SqlParser(tokens);
            return parser.sql_stmt_itself();
        }
        catch (RecognitionException re) {
            throw new SqlJetException(SqlJetErrorCode.ERROR, "Invalid sql statement: " + sql);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ISqlJetTableDef alterTable(String sql) throws SqlJetException {
        SqlJetAlterTableDef alterTableDef = new SqlJetAlterTableDef(this.parseSqlStatement(sql));
        this.db.getMutex().enter();
        try {
            ISqlJetTableDef iSqlJetTableDef = this.alterTableSafe(alterTableDef);
            return iSqlJetTableDef;
        }
        finally {
            this.db.getMutex().leave();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ISqlJetVirtualTableDef createVirtualTable(String sql, int page) throws SqlJetException {
        this.db.getMutex().enter();
        try {
            ISqlJetVirtualTableDef iSqlJetVirtualTableDef = this.createVirtualTableSafe(sql, page);
            return iSqlJetVirtualTableDef;
        }
        finally {
            this.db.getMutex().leave();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ISqlJetVirtualTableDef createVirtualTableSafe(String sql, int page) throws SqlJetException {
        RuleReturnScope parseTable = this.parseTable(sql);
        CommonTree ast = (CommonTree)parseTable.getTree();
        if (!this.isCreateVirtualTable(ast)) {
            throw new SqlJetException(SqlJetErrorCode.ERROR);
        }
        SqlJetVirtualTableDef tableDef = new SqlJetVirtualTableDef(ast, 0);
        if (null == tableDef.getTableName()) {
            throw new SqlJetException(SqlJetErrorCode.ERROR);
        }
        String tableName = tableDef.getTableName();
        if ("".equals(tableName)) {
            throw new SqlJetException(SqlJetErrorCode.ERROR);
        }
        this.checkNameReserved(tableName);
        this.checkFieldNamesRepeatsConflict(tableDef.getTableName(), tableDef.getModuleColumns());
        if (this.virtualTableDefs.containsKey(tableName)) {
            throw new SqlJetException(SqlJetErrorCode.ERROR, "Virtual table \"" + tableName + "\" exists already");
        }
        this.checkNameConflict(SqlJetSchemaObjectType.VIRTUAL_TABLE, tableName);
        ISqlJetBtreeSchemaTable schemaTable = this.openSchemaTable(true);
        String createVirtualTableSQL = this.getCreateVirtualTableSql(parseTable);
        try {
            SqlJetVirtualTableDef sqlJetVirtualTableDef;
            schemaTable.lock();
            try {
                this.db.getOptions().changeSchemaVersion();
                long rowId = schemaTable.insertRecord(TABLE_TYPE, tableName, tableName, page, createVirtualTableSQL);
                tableDef.setPage(page);
                tableDef.setRowId(rowId);
                this.virtualTableDefs.put(tableName, tableDef);
                sqlJetVirtualTableDef = tableDef;
            }
            catch (Throwable throwable) {
                schemaTable.unlock();
                throw throwable;
            }
            schemaTable.unlock();
            return sqlJetVirtualTableDef;
        }
        finally {
            schemaTable.close();
        }
    }

    public ISqlJetViewDef createView(String sql) throws SqlJetException {
        this.db.getMutex().enter();
        try {
            ISqlJetViewDef iSqlJetViewDef = this.createViewSafe(sql);
            return iSqlJetViewDef;
        }
        finally {
            this.db.getMutex().leave();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ISqlJetViewDef createViewSafe(String sql) throws SqlJetException {
        SqlJetViewDef viewDef;
        RuleReturnScope parseView = this.parseView(sql);
        CommonTree ast = (CommonTree)parseView.getTree();
        if ((sql = sql.trim()).endsWith(";")) {
            sql = sql.substring(0, sql.length() - 1);
        }
        if (null == (viewDef = new SqlJetViewDef(sql, ast)).getName()) {
            throw new SqlJetException(SqlJetErrorCode.ERROR);
        }
        String viewName = viewDef.getName();
        if ("".equals(viewName)) {
            throw new SqlJetException(SqlJetErrorCode.ERROR);
        }
        if (this.viewDefs.containsKey(viewName)) {
            if (viewDef.isKeepExisting()) {
                return this.viewDefs.get(viewName);
            }
            throw new SqlJetException(SqlJetErrorCode.ERROR, "View \"" + viewName + "\" exists already");
        }
        this.checkNameConflict(SqlJetSchemaObjectType.VIEW, viewName);
        ISqlJetBtreeSchemaTable schemaTable = this.openSchemaTable(true);
        try {
            SqlJetViewDef sqlJetViewDef;
            schemaTable.lock();
            try {
                this.db.getOptions().changeSchemaVersion();
                long rowId = schemaTable.insertRecord(VIEW_TYPE, viewName, viewName, 0, sql);
                viewDef.setRowId(rowId);
                this.viewDefs.put(viewName, viewDef);
                sqlJetViewDef = viewDef;
            }
            catch (Throwable throwable) {
                schemaTable.unlock();
                throw throwable;
            }
            schemaTable.unlock();
            return sqlJetViewDef;
        }
        finally {
            schemaTable.close();
        }
    }

    private void checkNameReserved(String name) throws SqlJetException {
        if (this.isNameReserved(name)) {
            throw new SqlJetException(String.format(NAME_RESERVED, name));
        }
    }

    public boolean isNameReserved(String name) {
        return name.startsWith("sqlite_");
    }

    private void checkNameConflict(SqlJetSchemaObjectType objectType, String tableName) throws SqlJetException {
        if (this.isNameConflict(objectType, tableName)) {
            throw new SqlJetException(String.format("Name conflict: %s named '%s' exists already", objectType.getName(), tableName));
        }
    }

    private boolean isNameConflict(SqlJetSchemaObjectType objectType, String name) {
        if (objectType != SqlJetSchemaObjectType.TABLE && this.tableDefs.containsKey(name)) {
            return true;
        }
        if (objectType != SqlJetSchemaObjectType.INDEX && this.indexDefs.containsKey(name)) {
            return true;
        }
        if (objectType != SqlJetSchemaObjectType.VIRTUAL_TABLE && this.virtualTableDefs.containsKey(name)) {
            return true;
        }
        if (objectType != SqlJetSchemaObjectType.VIEW && this.viewDefs.containsKey(name)) {
            return true;
        }
        return objectType != SqlJetSchemaObjectType.TRIGGER && this.triggerDefs.containsKey(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ISqlJetIndexDef createIndexForVirtualTable(String virtualTableName, String indexName) throws SqlJetException {
        this.db.getMutex().enter();
        try {
            ISqlJetIndexDef iSqlJetIndexDef = this.createIndexForVirtualTableSafe(virtualTableName, indexName);
            return iSqlJetIndexDef;
        }
        finally {
            this.db.getMutex().leave();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ISqlJetIndexDef createIndexForVirtualTableSafe(String virtualTableName, String indexName) throws SqlJetException {
        if (null == virtualTableName || "".equals(virtualTableName)) {
            throw new SqlJetException(SqlJetErrorCode.ERROR);
        }
        if (null == indexName || "".equals(indexName)) {
            throw new SqlJetException(SqlJetErrorCode.ERROR);
        }
        this.checkNameReserved(indexName);
        if (this.indexDefs.containsKey(indexName)) {
            throw new SqlJetException(SqlJetErrorCode.ERROR, "Index \"" + indexName + "\" exists already");
        }
        this.checkNameConflict(SqlJetSchemaObjectType.INDEX, indexName);
        ISqlJetVirtualTableDef tableDef = this.getVirtualTable(virtualTableName);
        if (null == tableDef) {
            throw new SqlJetException(SqlJetErrorCode.ERROR);
        }
        ISqlJetBtreeSchemaTable schemaTable = this.openSchemaTable(true);
        try {
            ISqlJetIndexDef iSqlJetIndexDef;
            schemaTable.lock();
            try {
                this.db.getOptions().changeSchemaVersion();
                ISqlJetIndexDef indexDef = this.createAutoIndex(schemaTable, tableDef.getTableName(), indexName);
                this.indexDefs.put(indexName, indexDef);
                iSqlJetIndexDef = indexDef;
            }
            catch (Throwable throwable) {
                schemaTable.unlock();
                throw throwable;
            }
            schemaTable.unlock();
            return iSqlJetIndexDef;
        }
        finally {
            schemaTable.close();
        }
    }

    public void dropView(String viewName) throws SqlJetException {
        this.db.getMutex().enter();
        try {
            this.dropViewSafe(viewName);
        }
        finally {
            this.db.getMutex().leave();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dropViewSafe(String viewName) throws SqlJetException {
        if (null == viewName || "".equals(viewName)) {
            throw new SqlJetException(SqlJetErrorCode.MISUSE, "View name must be not empty");
        }
        if (!this.viewDefs.containsKey(viewName)) {
            throw new SqlJetException(SqlJetErrorCode.MISUSE, "View not found: " + viewName);
        }
        SqlJetViewDef viewDef = (SqlJetViewDef)this.viewDefs.get(viewName);
        ISqlJetBtreeSchemaTable schemaTable = this.openSchemaTable(true);
        try {
            schemaTable.lock();
            try {
                this.db.getOptions().changeSchemaVersion();
                if (!schemaTable.goToRow(viewDef.getRowId()) || !VIEW_TYPE.equals(schemaTable.getTypeField())) {
                    throw new SqlJetException(SqlJetErrorCode.CORRUPT);
                }
                String n = schemaTable.getNameField();
                if (null == n || !viewName.equals(n)) {
                    throw new SqlJetException(SqlJetErrorCode.CORRUPT);
                }
                schemaTable.delete();
            }
            finally {
                schemaTable.unlock();
            }
        }
        finally {
            schemaTable.close();
        }
        this.viewDefs.remove(viewName);
    }

    public void dropTrigger(String triggerName) throws SqlJetException {
        this.db.getMutex().enter();
        try {
            this.dropTriggerSafe(triggerName);
        }
        finally {
            this.db.getMutex().leave();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dropTriggerSafe(String triggerName) throws SqlJetException {
        if (null == triggerName || "".equals(triggerName)) {
            throw new SqlJetException(SqlJetErrorCode.MISUSE, "Trigger name must be not empty");
        }
        if (!this.triggerDefs.containsKey(triggerName)) {
            throw new SqlJetException(SqlJetErrorCode.MISUSE, "Trigger not found: " + triggerName);
        }
        SqlJetTriggerDef triggerDef = (SqlJetTriggerDef)this.triggerDefs.get(triggerName);
        ISqlJetBtreeSchemaTable schemaTable = this.openSchemaTable(true);
        try {
            schemaTable.lock();
            try {
                this.db.getOptions().changeSchemaVersion();
                if (!schemaTable.goToRow(triggerDef.getRowId()) || !TRIGGER_TYPE.equals(schemaTable.getTypeField())) {
                    throw new SqlJetException(SqlJetErrorCode.CORRUPT);
                }
                String n = schemaTable.getNameField();
                if (null == n || !triggerName.equals(n)) {
                    throw new SqlJetException(SqlJetErrorCode.CORRUPT);
                }
                schemaTable.delete();
            }
            finally {
                schemaTable.unlock();
            }
        }
        finally {
            schemaTable.close();
        }
        this.triggerDefs.remove(triggerName);
    }

    public ISqlJetTriggerDef createTrigger(String sql) throws SqlJetException {
        this.db.getMutex().enter();
        try {
            ISqlJetTriggerDef iSqlJetTriggerDef = this.createTriggerSafe(sql);
            return iSqlJetTriggerDef;
        }
        finally {
            this.db.getMutex().leave();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ISqlJetTriggerDef createTriggerSafe(String sql) throws SqlJetException {
        SqlJetTriggerDef triggerDef;
        RuleReturnScope parseView = this.parseTrigger(sql);
        CommonTree ast = (CommonTree)parseView.getTree();
        if ((sql = sql.trim()).endsWith(";")) {
            sql = sql.substring(0, sql.length() - 1);
        }
        if (null == (triggerDef = new SqlJetTriggerDef(sql, ast)).getName()) {
            throw new SqlJetException(SqlJetErrorCode.ERROR);
        }
        String triggerName = triggerDef.getName();
        if ("".equals(triggerName)) {
            throw new SqlJetException(SqlJetErrorCode.ERROR);
        }
        String tableName = triggerDef.getTableName();
        if ("".equals(tableName)) {
            throw new SqlJetException(SqlJetErrorCode.ERROR);
        }
        if (this.triggerDefs.containsKey(triggerName)) {
            if (triggerDef.isKeepExisting()) {
                return this.triggerDefs.get(triggerName);
            }
            throw new SqlJetException(SqlJetErrorCode.ERROR, "Trigger \"" + triggerName + "\" already exists");
        }
        this.checkNameConflict(SqlJetSchemaObjectType.TRIGGER, triggerName);
        ISqlJetBtreeSchemaTable schemaTable = this.openSchemaTable(true);
        try {
            SqlJetTriggerDef sqlJetTriggerDef;
            schemaTable.lock();
            try {
                this.db.getOptions().changeSchemaVersion();
                long rowId = schemaTable.insertRecord(TRIGGER_TYPE, triggerName, tableName, 0, sql);
                triggerDef.setRowId(rowId);
                this.triggerDefs.put(triggerName, triggerDef);
                sqlJetTriggerDef = triggerDef;
            }
            catch (Throwable throwable) {
                schemaTable.unlock();
                throw throwable;
            }
            schemaTable.unlock();
            return sqlJetTriggerDef;
        }
        finally {
            schemaTable.close();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum SqlJetSchemaObjectType {
        TABLE{

            public Object getName() {
                return SqlJetSchema.TABLE_TYPE;
            }
        }
        ,
        INDEX{

            public Object getName() {
                return SqlJetSchema.INDEX_TYPE;
            }
        }
        ,
        VIRTUAL_TABLE{

            public Object getName() {
                return "virtual table";
            }
        }
        ,
        VIEW{

            public Object getName() {
                return SqlJetSchema.VIEW_TYPE;
            }
        }
        ,
        TRIGGER{

            public Object getName() {
                return SqlJetSchema.TRIGGER_TYPE;
            }
        };


        public abstract Object getName();
    }
}

