/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.scan.branch;

import org.picocontainer.annotations.Nullable;
import org.picocontainer.injectors.ProviderAdapter;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.api.utils.log.Profiler;
import org.sonar.scanner.scan.ProjectConfiguration;
import org.sonar.scanner.scan.branch.BranchConfiguration;
import org.sonar.scanner.scan.branch.BranchConfigurationLoader;
import org.sonar.scanner.scan.branch.DefaultBranchConfiguration;
import org.sonar.scanner.scan.branch.ProjectBranches;
import org.sonar.scanner.scan.branch.ProjectPullRequests;

public class BranchConfigurationProvider
extends ProviderAdapter {
    private static final Logger LOG = Loggers.get(BranchConfigurationProvider.class);
    private static final String LOG_MSG = "Load branch configuration";
    private BranchConfiguration branchConfiguration = null;

    public BranchConfiguration provide(@Nullable BranchConfigurationLoader loader, ProjectConfiguration projectConfiguration, ProjectBranches branches, ProjectPullRequests pullRequests) {
        if (this.branchConfiguration == null) {
            if (loader == null) {
                this.branchConfiguration = new DefaultBranchConfiguration();
            } else {
                Profiler profiler = Profiler.create(LOG).startInfo(LOG_MSG);
                this.branchConfiguration = loader.load(projectConfiguration.getProperties(), branches, pullRequests);
                profiler.stopInfo();
            }
        }
        return this.branchConfiguration;
    }
}

