/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.bootstrap;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.concurrent.Immutable;
import org.sonar.api.config.internal.Encryption;

@Immutable
public class ScannerProperties {
    private final Map<String, String> properties;
    private final Encryption encryption;

    public ScannerProperties(Map<String, String> properties) {
        this.encryption = new Encryption(properties.get("sonar.secretKeyPath"));
        HashMap<String, String> decryptedProps = new HashMap<String, String>(properties.size());
        for (Map.Entry<String, String> entry : properties.entrySet()) {
            String value = entry.getValue();
            if (value != null && this.encryption.isEncrypted(value)) {
                try {
                    value = this.encryption.decrypt(value);
                }
                catch (Exception e) {
                    throw new IllegalStateException("Fail to decrypt the property " + entry.getKey() + ". Please check your secret key.", e);
                }
            }
            decryptedProps.put(entry.getKey(), value);
        }
        this.properties = Collections.unmodifiableMap(new HashMap(decryptedProps));
    }

    public Encryption getEncryption() {
        return this.encryption;
    }

    public Map<String, String> properties() {
        return this.properties;
    }

    public String property(String key) {
        return this.properties.get(key);
    }

    public String getProjectKey() {
        return this.properties.get("sonar.projectKey");
    }
}

