/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.core.util;

import java.text.Normalizer;
import java.util.Locale;
import java.util.regex.Pattern;

public class Slug {
    private static final String DASH = "-";
    private static final Pattern NON_ASCII_CHARS = Pattern.compile("[^\\p{ASCII}]");
    private static final Pattern NON_WORD_CHARS = Pattern.compile("[^\\w+]");
    private static final Pattern WHITESPACES_CHARS = Pattern.compile("\\s+");
    private static final Pattern DASHES_IN_ROWS = Pattern.compile("[-]+");
    private String in;

    private Slug(String in) {
        this.in = in;
    }

    public static String slugify(String s) {
        Slug slug = new Slug(s);
        return slug.normalize().removeNonAsciiChars().dashifyNonWordChars().dashifyWhitespaceChars().collapseDashes().removeHeadingDash().removeTrailingDash().toLowerCase();
    }

    private Slug normalize() {
        this.in = Normalizer.normalize(this.in, Normalizer.Form.NFD);
        return this;
    }

    private Slug removeNonAsciiChars() {
        this.in = Slug.removeAll(NON_ASCII_CHARS, this.in);
        return this;
    }

    private Slug dashifyNonWordChars() {
        this.in = Slug.dashify(NON_WORD_CHARS, this.in);
        return this;
    }

    private Slug dashifyWhitespaceChars() {
        this.in = Slug.dashify(WHITESPACES_CHARS, this.in);
        return this;
    }

    private Slug collapseDashes() {
        this.in = Slug.dashify(DASHES_IN_ROWS, this.in);
        return this;
    }

    private Slug removeHeadingDash() {
        if (this.in.startsWith(DASH)) {
            this.in = this.in.substring(1);
        }
        return this;
    }

    private Slug removeTrailingDash() {
        if (this.in.endsWith(DASH)) {
            this.in = this.in.substring(0, this.in.length() - 1);
        }
        return this;
    }

    private String toLowerCase() {
        return this.in.toLowerCase(Locale.ENGLISH);
    }

    private static String removeAll(Pattern pattern, String in) {
        return Slug.replaceAll(pattern, in, "");
    }

    private static String dashify(Pattern pattern, String in) {
        return Slug.replaceAll(pattern, in, DASH);
    }

    private static String replaceAll(Pattern pattern, String str, String replacement) {
        return pattern.matcher(str).replaceAll(replacement);
    }
}

