/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch.bootstrapper;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.sonar.batch.bootstrapper.EnvironmentInformation;
import org.sonar.batch.bootstrapper.LogOutput;

public final class LoggingConfiguration {
    public static final String PROPERTY_ROOT_LOGGER_LEVEL = "ROOT_LOGGER_LEVEL";
    public static final String PROPERTY_FORMAT = "FORMAT";
    public static final String LEVEL_ROOT_VERBOSE = "DEBUG";
    public static final String LEVEL_ROOT_DEFAULT = "INFO";
    static final String FORMAT_DEFAULT = "%d{HH:mm:ss.SSS} %-5level - %msg%n";
    static final String FORMAT_MAVEN = "[%level] [%d{HH:mm:ss.SSS}] %msg%n";
    private Map<String, String> substitutionVariables = new HashMap<String, String>();
    private LogOutput logOutput = null;
    private boolean verbose;

    public LoggingConfiguration() {
        this(null);
    }

    public LoggingConfiguration(@Nullable EnvironmentInformation environment) {
        this.setVerbose(false);
        if (environment != null && "maven".equalsIgnoreCase(environment.getKey())) {
            this.setFormat(FORMAT_MAVEN);
        } else {
            this.setFormat(FORMAT_DEFAULT);
        }
    }

    public LoggingConfiguration setProperties(Map<String, String> properties) {
        this.setVerbose(properties);
        return this;
    }

    public LoggingConfiguration setLogOutput(@Nullable LogOutput listener) {
        this.logOutput = listener;
        return this;
    }

    public LoggingConfiguration setVerbose(boolean verbose) {
        return this.setRootLevel(verbose ? LEVEL_ROOT_VERBOSE : LEVEL_ROOT_DEFAULT);
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public LoggingConfiguration setVerbose(Map<String, String> props) {
        String logLevel = props.get("sonar.log.level");
        String deprecatedProfilingLevel = props.get("sonar.log.profilingLevel");
        this.verbose = "true".equals(props.get("sonar.verbose")) || LEVEL_ROOT_VERBOSE.equals(logLevel) || "TRACE".equals(logLevel) || "BASIC".equals(deprecatedProfilingLevel) || "FULL".equals(deprecatedProfilingLevel);
        return this.setVerbose(this.verbose);
    }

    public LoggingConfiguration setRootLevel(String level) {
        return this.addSubstitutionVariable(PROPERTY_ROOT_LOGGER_LEVEL, level);
    }

    LoggingConfiguration setFormat(String format) {
        return this.addSubstitutionVariable(PROPERTY_FORMAT, StringUtils.defaultIfBlank(format, FORMAT_DEFAULT));
    }

    private LoggingConfiguration addSubstitutionVariable(String key, String value) {
        this.substitutionVariables.put(key, value);
        return this;
    }

    String getSubstitutionVariable(String key) {
        return this.substitutionVariables.get(key);
    }

    Map<String, String> getSubstitutionVariables() {
        return this.substitutionVariables;
    }

    LogOutput getLogOutput() {
        return this.logOutput;
    }
}

