/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.server.rule.internal;

import java.io.IOException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.api.internal.apachecommons.io.IOUtils;
import org.sonar.api.internal.apachecommons.lang.StringUtils;
import org.sonar.api.rule.RuleKey;
import org.sonar.api.rule.RuleScope;
import org.sonar.api.rule.RuleStatus;
import org.sonar.api.rule.Severity;
import org.sonar.api.rules.RuleType;
import org.sonar.api.server.debt.DebtRemediationFunction;
import org.sonar.api.server.rule.RuleTagFormat;
import org.sonar.api.server.rule.RulesDefinition;
import org.sonar.api.server.rule.internal.DefaultDebtRemediationFunctions;
import org.sonar.api.server.rule.internal.DefaultNewParam;
import org.sonar.api.utils.Preconditions;

class DefaultNewRule
extends RulesDefinition.NewRule {
    private final String pluginKey;
    private final String repoKey;
    private final String key;
    private RuleType type;
    private String name;
    private String htmlDescription;
    private String markdownDescription;
    private String internalKey;
    private String severity = "MAJOR";
    private boolean template;
    private RuleStatus status = RuleStatus.defaultStatus();
    private DebtRemediationFunction debtRemediationFunction;
    private String gapDescription;
    private final Set<String> tags = new TreeSet<String>();
    private final Set<String> securityStandards = new TreeSet<String>();
    private final Map<String, RulesDefinition.NewParam> paramsByKey = new HashMap<String, RulesDefinition.NewParam>();
    private final RulesDefinition.DebtRemediationFunctions functions;
    private boolean activatedByDefault;
    private RuleScope scope;
    private final Set<RuleKey> deprecatedRuleKeys = new TreeSet<RuleKey>();

    DefaultNewRule(@Nullable String pluginKey, String repoKey, String key) {
        this.pluginKey = pluginKey;
        this.repoKey = repoKey;
        this.key = key;
        this.functions = new DefaultDebtRemediationFunctions(repoKey, key);
    }

    @Override
    public String key() {
        return this.key;
    }

    @Override
    @CheckForNull
    public RuleScope scope() {
        return this.scope;
    }

    @Override
    public DefaultNewRule setScope(RuleScope scope) {
        this.scope = scope;
        return this;
    }

    @Override
    public DefaultNewRule setName(String s) {
        this.name = StringUtils.trimToNull(s);
        return this;
    }

    @Override
    public DefaultNewRule setTemplate(boolean template) {
        this.template = template;
        return this;
    }

    @Override
    public DefaultNewRule setActivatedByDefault(boolean activatedByDefault) {
        this.activatedByDefault = activatedByDefault;
        return this;
    }

    @Override
    public DefaultNewRule setSeverity(String s) {
        Preconditions.checkArgument(Severity.ALL.contains(s), "Severity of rule %s is not correct: %s", this, s);
        this.severity = s;
        return this;
    }

    @Override
    public DefaultNewRule setType(RuleType t) {
        this.type = t;
        return this;
    }

    @Override
    public DefaultNewRule setHtmlDescription(@Nullable String s) {
        Preconditions.checkState(this.markdownDescription == null, "Rule '%s' already has a Markdown description", this);
        this.htmlDescription = StringUtils.trimToNull(s);
        return this;
    }

    @Override
    public DefaultNewRule setHtmlDescription(@Nullable URL classpathUrl) {
        if (classpathUrl != null) {
            try {
                this.setHtmlDescription(IOUtils.toString(classpathUrl, StandardCharsets.UTF_8));
            }
            catch (IOException e) {
                throw new IllegalStateException("Fail to read: " + classpathUrl, e);
            }
        } else {
            this.htmlDescription = null;
        }
        return this;
    }

    @Override
    public DefaultNewRule setMarkdownDescription(@Nullable String s) {
        Preconditions.checkState(this.htmlDescription == null, "Rule '%s' already has an HTML description", this);
        this.markdownDescription = StringUtils.trimToNull(s);
        return this;
    }

    @Override
    public DefaultNewRule setMarkdownDescription(@Nullable URL classpathUrl) {
        if (classpathUrl != null) {
            try {
                this.setMarkdownDescription(IOUtils.toString(classpathUrl, StandardCharsets.UTF_8));
            }
            catch (IOException e) {
                throw new IllegalStateException("Fail to read: " + classpathUrl, e);
            }
        } else {
            this.markdownDescription = null;
        }
        return this;
    }

    @Override
    public DefaultNewRule setStatus(RuleStatus status) {
        Preconditions.checkArgument(RuleStatus.REMOVED != status, "Status 'REMOVED' is not accepted on rule '%s'", this);
        this.status = status;
        return this;
    }

    @Override
    public RulesDefinition.DebtRemediationFunctions debtRemediationFunctions() {
        return this.functions;
    }

    @Override
    public DefaultNewRule setDebtRemediationFunction(@Nullable DebtRemediationFunction fn) {
        this.debtRemediationFunction = fn;
        return this;
    }

    @Override
    public DefaultNewRule setGapDescription(@Nullable String s) {
        this.gapDescription = s;
        return this;
    }

    @Override
    public RulesDefinition.NewParam createParam(String paramKey) {
        Preconditions.checkArgument(!this.paramsByKey.containsKey(paramKey), "The parameter '%s' is declared several times on the rule %s", paramKey, this);
        DefaultNewParam param = new DefaultNewParam(paramKey);
        this.paramsByKey.put(paramKey, param);
        return param;
    }

    @Override
    @CheckForNull
    public RulesDefinition.NewParam param(String paramKey) {
        return this.paramsByKey.get(paramKey);
    }

    @Override
    public Collection<RulesDefinition.NewParam> params() {
        return this.paramsByKey.values();
    }

    @Override
    public DefaultNewRule addTags(String ... list) {
        for (String tag : list) {
            RuleTagFormat.validate(tag);
            this.tags.add(tag);
        }
        return this;
    }

    @Override
    public DefaultNewRule setTags(String ... list) {
        this.tags.clear();
        this.addTags(list);
        return this;
    }

    @Override
    public DefaultNewRule addOwaspTop10(RulesDefinition.OwaspTop10 ... standards) {
        return this.addOwaspTop10(RulesDefinition.OwaspTop10Version.Y2017, standards);
    }

    @Override
    public DefaultNewRule addOwaspTop10(RulesDefinition.OwaspTop10Version version, RulesDefinition.OwaspTop10 ... standards) {
        Objects.requireNonNull(version, "Owasp version must not be null");
        String versionPrefix = RulesDefinition.OwaspTop10Version.Y2017.equals((Object)version) ? "owaspTop10:" : "owaspTop10-" + version.label() + ":";
        for (RulesDefinition.OwaspTop10 owaspTop10 : standards) {
            String standard = versionPrefix + owaspTop10.name().toLowerCase(Locale.ENGLISH);
            this.securityStandards.add(standard);
        }
        return this;
    }

    @Override
    public DefaultNewRule addCwe(int ... nums) {
        for (int num : nums) {
            String standard = "cwe:" + num;
            this.securityStandards.add(standard);
        }
        return this;
    }

    @Override
    public DefaultNewRule setInternalKey(@Nullable String s) {
        this.internalKey = s;
        return this;
    }

    void validate() {
        if (StringUtils.isEmpty(this.name)) {
            throw new IllegalStateException(String.format("Name of rule %s is empty", this));
        }
        if (StringUtils.isEmpty(this.htmlDescription) && StringUtils.isEmpty(this.markdownDescription)) {
            throw new IllegalStateException(String.format("One of HTML description or Markdown description must be defined for rule %s", this));
        }
    }

    @Override
    public DefaultNewRule addDeprecatedRuleKey(String repository, String key) {
        this.deprecatedRuleKeys.add(RuleKey.of(repository, key));
        return this;
    }

    String pluginKey() {
        return this.pluginKey;
    }

    String repoKey() {
        return this.repoKey;
    }

    RuleType type() {
        return this.type;
    }

    String name() {
        return this.name;
    }

    String htmlDescription() {
        return this.htmlDescription;
    }

    String markdownDescription() {
        return this.markdownDescription;
    }

    @CheckForNull
    String internalKey() {
        return this.internalKey;
    }

    String severity() {
        return this.severity;
    }

    boolean template() {
        return this.template;
    }

    RuleStatus status() {
        return this.status;
    }

    DebtRemediationFunction debtRemediationFunction() {
        return this.debtRemediationFunction;
    }

    String gapDescription() {
        return this.gapDescription;
    }

    Set<String> tags() {
        return this.tags;
    }

    Set<String> securityStandards() {
        return this.securityStandards;
    }

    Map<String, RulesDefinition.NewParam> paramsByKey() {
        return this.paramsByKey;
    }

    boolean activatedByDefault() {
        return this.activatedByDefault;
    }

    Set<RuleKey> deprecatedRuleKeys() {
        return this.deprecatedRuleKeys;
    }

    public String toString() {
        return String.format("[repository=%s, key=%s]", this.repoKey, this.key);
    }
}

