/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.config.internal;

import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.security.SecureRandom;
import javax.annotation.Nullable;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.sonar.api.config.internal.Cipher;

abstract class AesCipher
implements Cipher {
    static final int KEY_SIZE_IN_BITS = 256;
    private static final String CRYPTO_KEY = "AES";
    private String pathToSecretKey;

    AesCipher(@Nullable String pathToSecretKey) {
        this.pathToSecretKey = pathToSecretKey;
    }

    boolean hasSecretKey() {
        String path = this.getPathToSecretKey();
        if (StringUtils.isNotBlank(path)) {
            File file = new File(path);
            return file.exists() && file.isFile();
        }
        return false;
    }

    protected Key loadSecretFile() throws IOException {
        String path = this.getPathToSecretKey();
        return this.loadSecretFileFromFile(path);
    }

    Key loadSecretFileFromFile(@Nullable String path) throws IOException {
        if (StringUtils.isBlank(path)) {
            throw new IllegalStateException("Secret key not found. Please set the property sonar.secretKeyPath");
        }
        File file = new File(path);
        if (!file.exists() || !file.isFile()) {
            throw new IllegalStateException("The property sonar.secretKeyPath does not link to a valid file: " + path);
        }
        String s = FileUtils.readFileToString(file, StandardCharsets.UTF_8);
        if (StringUtils.isBlank(s)) {
            throw new IllegalStateException("No secret key in the file: " + path);
        }
        return new SecretKeySpec(Base64.decodeBase64(StringUtils.trim(s)), CRYPTO_KEY);
    }

    String generateRandomSecretKey() {
        try {
            KeyGenerator keyGen = KeyGenerator.getInstance(CRYPTO_KEY);
            keyGen.init(256, new SecureRandom());
            SecretKey secretKey = keyGen.generateKey();
            return Base64.encodeBase64String(secretKey.getEncoded());
        }
        catch (Exception e) {
            throw new IllegalStateException("Fail to generate secret key", e);
        }
    }

    String getPathToSecretKey() {
        if (StringUtils.isBlank(this.pathToSecretKey)) {
            this.pathToSecretKey = new File(FileUtils.getUserDirectoryPath(), ".sonar/sonar-secret.txt").getPath();
        }
        return this.pathToSecretKey;
    }

    public void setPathToSecretKey(@Nullable String pathToSecretKey) {
        this.pathToSecretKey = pathToSecretKey;
    }
}

